/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.api;

import com.t4a.api.AIAction;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionKey {
    private static final Logger log = LoggerFactory.getLogger(ActionKey.class);
    private String actionName;
    private String actionDescription;
    private long uniqueKey;

    public ActionKey(AIAction action) {
        this.generateUniqueKey();
        this.actionName = action.getActionName();
        this.actionDescription = action.getDescription();
    }

    private void generateUniqueKey() {
        UUID uuid = UUID.randomUUID();
        this.uniqueKey = uuid.getMostSignificantBits() & Long.MAX_VALUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionKey actionKey = (ActionKey)o;
        return Objects.equals(this.uniqueKey, actionKey.uniqueKey);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueKey);
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public long getUniqueKey() {
        return this.uniqueKey;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setActionDescription(String actionDescription) {
        this.actionDescription = actionDescription;
    }

    public void setUniqueKey(long uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public ActionKey() {
    }
}

