/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.api;

import com.t4a.annotations.Action;
import com.t4a.annotations.Agent;
import com.t4a.api.ActionRisk;
import com.t4a.api.JavaMethodAction;
import com.t4a.processor.AIProcessingException;
import java.lang.reflect.Method;

public class GenericJavaMethodAction
implements JavaMethodAction {
    private String actionClassName;
    private String actionName;
    private String description;
    private ActionRisk riskLevel = ActionRisk.LOW;
    private String groupName = "No Group";
    private String groupDescription = "tasks which are not categorized";
    private Class clazz;
    private Object actionInstance = null;
    private Method actionMethod = null;

    public GenericJavaMethodAction(Object actionInstance, String actionName) throws AIProcessingException {
        this(actionInstance.getClass(), actionName);
        this.actionInstance = actionInstance;
    }

    public GenericJavaMethodAction(Object actionInstance) throws AIProcessingException {
        this.actionInstance = actionInstance;
        this.init(actionInstance.getClass(), this.getAnnotatedMethods(actionInstance.getClass()));
    }

    public GenericJavaMethodAction(Class<?> clazz, String actionName) throws AIProcessingException {
        Method[] methods;
        Agent predict = clazz.getAnnotation(Agent.class);
        for (Method m1 : methods = clazz.getMethods()) {
            if (!m1.getName().equals(actionName)) continue;
            this.actionMethod = m1;
            break;
        }
        if (this.actionMethod == null) {
            throw new AIProcessingException(actionName + " method not found in class " + clazz.getName());
        }
        this.clazz = clazz;
        this.actionName = actionName;
        if (predict != null) {
            this.groupDescription = predict.groupDescription();
            this.groupName = predict.groupName();
        }
        this.actionClassName = clazz.getName();
        this.initAction(this.actionMethod);
    }

    public GenericJavaMethodAction(Class clazz, Method actionMethod) throws AIProcessingException {
        this.init(clazz, actionMethod);
    }

    private void init(Class clazz, Method actionMethod) throws AIProcessingException {
        Agent predict = clazz.getAnnotation(Agent.class);
        this.clazz = clazz;
        this.actionName = actionMethod.getName();
        this.actionMethod = actionMethod;
        if (predict != null) {
            this.groupDescription = predict.groupDescription();
            this.groupName = predict.groupName();
        }
        this.actionClassName = clazz.getName();
        this.initAction(actionMethod);
    }

    public Method getAnnotatedMethods(Class<?> clazz) {
        Method firstAnnotatedMethod = null;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Action.class)) continue;
            firstAnnotatedMethod = method;
            break;
        }
        return firstAnnotatedMethod;
    }

    private void initAction(Method actionMethod) {
        Action action = actionMethod.getAnnotation(Action.class);
        this.riskLevel = action.riskLevel();
        this.description = action.description();
        if (this.description == null || this.description.isEmpty()) {
            this.description = actionMethod.getName();
        }
    }

    @Override
    public String getActionName() {
        return this.actionName;
    }

    @Override
    public String getActionGroup() {
        return this.groupName;
    }

    @Override
    public ActionRisk getActionRisk() {
        return this.riskLevel;
    }

    @Override
    public String getActionClassName() {
        return this.actionClassName;
    }

    public Class getActionClass() {
        return this.clazz;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setActionInstance(Object actionInstance) {
        this.actionInstance = actionInstance;
    }

    @Override
    public Object getActionInstance() {
        return this.actionInstance;
    }

    public Method getActionMethod() {
        return this.actionMethod;
    }
}

