/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.api;

import com.t4a.annotations.Action;
import com.t4a.annotations.Agent;
import com.t4a.api.AIAction;
import com.t4a.api.ActionRisk;
import com.t4a.api.ActionType;
import com.t4a.processor.AIProcessingException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public interface JavaMethodAction
extends AIAction {
    @Override
    default public ActionType getActionType() {
        return ActionType.JAVAMETHOD;
    }

    @Override
    default public String getActionName() {
        Method firstAnnotatedMethod = null;
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Action.class)) continue;
            firstAnnotatedMethod = method;
            break;
        }
        if (firstAnnotatedMethod == null) {
            return "No action name available";
        }
        return firstAnnotatedMethod.getName();
    }

    default public String getActionClassName() {
        return this.getClass().getName();
    }

    default public Class<?> getActionClass() {
        return this.getClass();
    }

    @Override
    default public String getDescription() {
        Method firstAnnotatedMethod = null;
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Action.class)) continue;
            firstAnnotatedMethod = method;
            break;
        }
        if (firstAnnotatedMethod == null) {
            return "No description available";
        }
        Action action = firstAnnotatedMethod.getAnnotation(Action.class);
        String description = action.description();
        if (description == null || description.isEmpty()) {
            description = firstAnnotatedMethod.getName();
        }
        return description;
    }

    @Override
    default public ActionRisk getActionRisk() {
        return ActionRisk.LOW;
    }

    @Override
    default public String getActionGroup() {
        Agent predict = this.getActionClass().getAnnotation(Agent.class);
        return predict != null ? predict.groupName() : "No group name available";
    }

    @Override
    default public String getGroupDescription() {
        Agent predict = this.getActionClass().getAnnotation(Agent.class);
        return predict != null ? predict.groupDescription() : "No group description available";
    }

    default public Object getActionInstance() {
        return this;
    }

    default public boolean isComplexMethod() throws AIProcessingException {
        Method[] met;
        boolean iscomplex = false;
        for (Method methood : met = this.getClass().getMethods()) {
            Parameter[] params;
            if (!methood.getName().equals(this.getActionName())) continue;
            for (Parameter param : params = methood.getParameters()) {
                Class<?> type = param.getType();
                iscomplex = type != String.class && type != Integer.TYPE && type != Integer.class && type != Double.TYPE && type != Double.class && type != Boolean.TYPE && type != Boolean.class && !type.isArray();
            }
        }
        return iscomplex;
    }
}

