/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.api;

import com.t4a.JsonUtils;
import com.t4a.api.ValueParser;
import com.t4a.api.ValueParserFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaMethodInvoker {
    private static final Logger log = LoggerFactory.getLogger(JavaMethodInvoker.class);
    private final ValueParserFactory parserFactory = new ValueParserFactory();

    public Object[] parse(String jsonStr) {
        JsonUtils utils = new JsonUtils();
        jsonStr = utils.extractJson(jsonStr);
        JSONObject jsonObject = new JSONObject(jsonStr);
        String methodName = jsonObject.getString("methodName");
        String returnType = jsonObject.getString("returnType");
        JSONArray parametersArray = jsonObject.getJSONArray("parameters");
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        ArrayList parameterTypes = new ArrayList();
        Object[] returnObject = new Object[]{parameterTypes, parameterValues};
        try {
            for (int i = 0; i < parametersArray.length(); ++i) {
                Object value;
                JSONObject paramObj = parametersArray.getJSONObject(i);
                String type = paramObj.getString("type");
                Class<?> parameterType = this.getType(type, paramObj);
                if (paramObj.has("fieldValue")) {
                    value = this.getValue(paramObj.get("fieldValue"), parameterType, paramObj);
                } else if (paramObj.has("fields")) {
                    value = this.createPOJO(paramObj.getJSONArray("fields"), Class.forName(type));
                } else {
                    throw new IllegalArgumentException("No value or fields found for parameter: " + paramObj.getString("name"));
                }
                parameterTypes.add(parameterType);
                parameterValues.add(value);
            }
            return returnObject;
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return new Object[0];
        }
    }

    private Object getValue(Object value, Class<?> type, JSONObject paramObj) {
        log.info("parsing value type {}, value {}, param {}", new Object[]{type.getName(), value, paramObj.optString("fieldName")});
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            return null;
        }
        ValueParser parser = this.parserFactory.getParser(type);
        if (parser != null) {
            return parser.parse(value, paramObj);
        }
        if (type == String.class) {
            return value.toString();
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(value.toString());
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(value.toString());
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(value.toString());
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(value.toString());
        }
        if (type.isArray()) {
            return this.handleArrayType(value, type, paramObj);
        }
        if (type.getName().equalsIgnoreCase("java.util.List")) {
            return value;
        }
        return this.handleCustomType(type);
    }

    private Object handleArrayType(Object value, Class<?> type, JSONObject paramObj) {
        JSONArray jsonArray = paramObj.getJSONArray("fieldValue");
        int length = jsonArray.length();
        Class<?> componentType = type.getComponentType();
        Object array = Array.newInstance(componentType, length);
        for (int i = 0; i < length; ++i) {
            JsonUtils utils = new JsonUtils();
            Object elementValue = null;
            try {
                Object insideObject = jsonArray.get(i);
                elementValue = insideObject instanceof JSONObject ? utils.populateObject((JSONObject)insideObject, paramObj) : this.getValue(insideObject, componentType, paramObj);
            }
            catch (Exception e) {
                log.warn("not able to populate {}", (Object)paramObj);
            }
            Array.set(array, i, elementValue);
        }
        return array;
    }

    private Object handleCustomType(Class<?> type) {
        try {
            Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    @NotNull
    private Class<?> getType(String type, JSONObject jsonObject) throws ClassNotFoundException {
        if (type.endsWith("[]")) {
            String componentTypeName = type.substring(0, type.length() - 2);
            Class<?> componentType = this.getType(jsonObject.getString("className"), jsonObject);
            return Array.newInstance(componentType, 0).getClass();
        }
        Class parameterType = type.equalsIgnoreCase("String") ? String.class : (type.equalsIgnoreCase("int") ? Integer.TYPE : (type.equalsIgnoreCase("double") ? Double.TYPE : (type.equalsIgnoreCase("boolean") ? Boolean.TYPE : (type.equalsIgnoreCase("Date") ? Date.class : (type.equalsIgnoreCase("list") ? Class.forName("java.util.List") : Class.forName(type))))));
        return parameterType;
    }

    public Object createPOJO(JSONArray fieldsArray, Class<?> clazz) throws Exception {
        HashMap instance;
        if (clazz.getName().equalsIgnoreCase("java.util.Map")) {
            instance = new HashMap();
            JsonUtils utls = new JsonUtils();
            utls.buildMapFromJsonArray(fieldsArray, instance);
        } else {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            for (int i = 0; i < fieldsArray.length(); ++i) {
                ArrayList fieldValue;
                JSONObject fieldObj = fieldsArray.getJSONObject(i);
                String fieldName = fieldObj.getString("fieldName");
                String fieldType = fieldObj.getString("fieldType");
                Class<?> parameterType = this.getType(fieldType, fieldObj);
                if (fieldObj.has("fieldValue")) {
                    fieldValue = this.getValue(fieldObj.get("fieldValue"), parameterType, fieldObj);
                } else if (fieldObj.has("fields")) {
                    fieldValue = this.createPOJO(fieldObj.getJSONArray("fields"), Class.forName(fieldType));
                } else {
                    throw new IllegalArgumentException("No value or fields found for parameter: " + fieldObj.getString("name"));
                }
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                if (fieldValue instanceof JSONObject || fieldValue instanceof JSONArray) {
                    if (fieldType.equalsIgnoreCase("list")) {
                        JSONArray listArray = fieldObj.getJSONArray("fieldValue");
                        String classNameList = fieldObj.getString("className");
                        Class<?> listClazz = Class.forName(classNameList);
                        ArrayList objList = new ArrayList();
                        for (Object obj : listArray) {
                            if (!(listClazz.isPrimitive() || listClazz.equals(String.class) || listClazz.equals(Date.class) || listClazz.isArray() || List.class.isAssignableFrom(listClazz))) {
                                JsonUtils util = new JsonUtils();
                                objList.add(listClazz.cast(util.populateObject((JSONObject)obj, fieldObj)));
                                continue;
                            }
                            objList.add(listClazz.cast(obj));
                        }
                        fieldValue = objList;
                    } else {
                        fieldValue = this.createPOJO(fieldValue, Class.forName(fieldType));
                    }
                }
                if (fieldValue == null) continue;
                field.set(instance, fieldValue);
            }
        }
        return instance;
    }

    public Object createPOJO(Object fieldValue, Class<?> clazz) throws Exception {
        if (fieldValue instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)fieldValue;
            JSONArray jsonArray = jsonObject.optJSONArray("fields");
            if (jsonArray != null) {
                return this.createPOJO(jsonArray, clazz);
            }
            jsonObject = ((JSONObject)fieldValue).optJSONObject("fieldValue");
            return this.createPOJO(jsonObject, clazz);
        }
        if (fieldValue instanceof JSONArray) {
            ArrayList<Object> nestedList = new ArrayList<Object>();
            JSONArray jsonArray = (JSONArray)fieldValue;
            for (int i = 0; i < jsonArray.length(); ++i) {
                nestedList.add(this.createPOJO(jsonArray.getJSONObject(i), clazz));
            }
            return nestedList;
        }
        return fieldValue;
    }
}

