/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.detect;

import com.t4a.api.AIPlatform;
import com.t4a.api.GuardRailException;
import com.t4a.detect.DetectValueRes;
import com.t4a.detect.DetectValues;
import com.t4a.detect.HallucinationAction;
import com.t4a.processor.AIProcessingException;
import com.t4a.processor.AIProcessor;
import com.t4a.processor.AnthropicActionProcessor;
import com.t4a.processor.GeminiV2ActionProcessor;
import com.t4a.processor.OpenAiActionProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroShotHallucinationDetector {
    private static final Logger log = LoggerFactory.getLogger(ZeroShotHallucinationDetector.class);
    private AIProcessor processor;
    private int numberOfQuestions = 4;
    private String breakIntoQuestionPrompt = "Can you derive 4 questions from this context and provide me a single line without line breaks or backslash n character, you should reply with questions and nothing else - ";

    public ZeroShotHallucinationDetector(AIPlatform platform) {
        if (platform == AIPlatform.GEMINI) {
            this.processor = new GeminiV2ActionProcessor();
        } else if (platform == AIPlatform.OPENAI) {
            this.processor = new OpenAiActionProcessor();
        } else if (platform == AIPlatform.ANTHROPIC) {
            this.processor = new AnthropicActionProcessor();
        } else {
            log.error("Platform not supported");
        }
    }

    public ZeroShotHallucinationDetector(AIProcessor processor) {
        this.processor = processor;
    }

    public DetectValueRes execute(DetectValues dd) throws GuardRailException, AIProcessingException {
        DetectValueRes res = new DetectValueRes();
        String questions = this.query(this.breakIntoQuestionPrompt + dd.getResponse());
        log.debug(questions);
        HallucinationAction questionAction = new HallucinationAction(this.processor, dd.getResponse());
        String responseStr = this.query("ask these questions -  " + questions + " - end of questions");
        List hallucinationList = (List)this.processor.processSingleAction(responseStr, questionAction);
        res.setHallucinationList(hallucinationList);
        return res;
    }

    private String query(String prompt) throws AIProcessingException {
        return this.processor.query(prompt);
    }

    public ZeroShotHallucinationDetector(AIProcessor processor, int numberOfQuestions, String breakIntoQuestionPrompt) {
        this.processor = processor;
        this.numberOfQuestions = numberOfQuestions;
        this.breakIntoQuestionPrompt = breakIntoQuestionPrompt;
    }
}

