/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.predict;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.google.cloud.vertexai.VertexAI;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.generativeai.ChatSession;
import com.google.cloud.vertexai.generativeai.GenerativeModel;
import com.google.cloud.vertexai.generativeai.ResponseHandler;
import com.google.gson.Gson;
import com.t4a.JsonUtils;
import com.t4a.action.ExtendedPredictedAction;
import com.t4a.action.http.HttpPredictedAction;
import com.t4a.annotations.Action;
import com.t4a.annotations.ActivateLoader;
import com.t4a.annotations.Agent;
import com.t4a.api.AIAction;
import com.t4a.api.AIPlatform;
import com.t4a.api.ActionGroup;
import com.t4a.api.ActionList;
import com.t4a.api.ActionType;
import com.t4a.api.GenericJavaMethodAction;
import com.t4a.predict.ExtendedPredictionLoader;
import com.t4a.predict.HttpRestPredictionLoader;
import com.t4a.predict.LoaderException;
import com.t4a.predict.ShellPredictionLoader;
import com.t4a.predict.SwaggerPredictionLoader;
import com.t4a.processor.AIProcessingException;
import dev.langchain4j.model.anthropic.AnthropicChatModel;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.openai.OpenAiChatModel;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PredictionLoader {
    private static final Logger log = LoggerFactory.getLogger(PredictionLoader.class);
    public static final String PRMPT = " This is the prompt - {";
    public static final String GRP = "} - which group does it belong - {";
    public static final String LOOK_FOR_ACTION_IN_THE_GROUP = " will look for action in the group ";
    public static final String OUT_OF = " out of ";
    private final Map<String, AIAction> predictions = new HashMap<String, AIAction>();
    private final StringBuilder actionNameList = new StringBuilder();
    private final ActionList actionGroupList = new ActionList();
    private static PredictionLoader predictionLoader = null;
    private final String PREACTIONCMD = "here is my prompt - ";
    private String PREACTIONCMDOI = "here is my prompt - ";
    private String ACTIONCMDOI = "- what action do you think we should take out of these  - {  ";
    private String POSTACTIONCMDOI = " } - reply back with ";
    public String METHODTOJSONOI = "- if you find the field named fieldValue, populate the field else and return the json as is";
    private final String ACTIONCMD = "- what action do you think we should take out of these  - {  ";
    private final String POSTACTIONCMD = " } - reply back with ";
    private final String NUMACTION = " action only. Make sure Action matches exactly from this list";
    private String NUMACTIONOI = " action only. Make sure Action matches exactly from this list";
    private final String NUMACTION_MULTIPROMPT = " actions only, in comma seperated list without any additional special characters";
    private ChatSession chat;
    private ChatSession chatExplain;
    private ChatSession chatMulti;
    private ChatSession chatGroupFinder;
    private String projectId;
    private String location;
    private String modelName;
    private String geminiVisionModelName;
    private ChatLanguageModel anthropicChatModel;
    private String anthropicModelName;
    private boolean anthropicLogReqFlag;
    private boolean anthropicLogResFlag;
    private ChatLanguageModel openAiChatModel;
    private String openAiKey;
    private String claudeKey;
    private String serperKey;
    private String actionGroupJson;
    private ApplicationContext springContext;

    private PredictionLoader() {
        this.initPromptProp();
        this.initModelProp();
        if (this.modelName != null && this.projectId != null && this.location != null) {
            try (VertexAI vertexAI = new VertexAI(this.projectId, this.location);){
                GenerativeModel model = new GenerativeModel.Builder().setModelName(this.modelName).setVertexAi(vertexAI).build();
                GenerativeModel modelExplain = new GenerativeModel.Builder().setModelName(this.modelName).setVertexAi(vertexAI).build();
                GenerativeModel multiCommand = new GenerativeModel.Builder().setModelName(this.modelName).setVertexAi(vertexAI).build();
                GenerativeModel chatGroupFinderCommand = new GenerativeModel.Builder().setModelName(this.modelName).setVertexAi(vertexAI).build();
                this.chat = model.startChat();
                this.chatExplain = modelExplain.startChat();
                this.chatMulti = multiCommand.startChat();
                this.chatGroupFinder = chatGroupFinderCommand.startChat();
            }
        }
        if (this.openAiKey != null) {
            this.openAiChatModel = OpenAiChatModel.withApiKey((String)this.openAiKey);
        }
        if (this.claudeKey != null) {
            this.anthropicChatModel = AnthropicChatModel.builder().apiKey(this.claudeKey).modelName(this.anthropicModelName).logRequests(Boolean.valueOf(this.anthropicLogReqFlag)).logResponses(Boolean.valueOf(this.anthropicLogResFlag)).maxTokens(Integer.valueOf(4000)).build();
        }
    }

    private void initPromptProp() {
        try (InputStream inputStream = PredictionLoader.class.getClassLoader().getResourceAsStream("prompt.properties");){
            if (inputStream == null) {
                log.error(" prompt properties not found ");
                return;
            }
            Properties prop = new Properties();
            prop.load(inputStream);
            this.PREACTIONCMDOI = prop.getProperty("openai.pre_action");
            if (this.PREACTIONCMDOI == null) {
                this.PREACTIONCMDOI = "here is my prompt - ";
            }
            this.ACTIONCMDOI = prop.getProperty("openai.action");
            if (this.ACTIONCMDOI == null) {
                this.ACTIONCMDOI = "- what action do you think we should take out of these  - {  ";
            }
            this.POSTACTIONCMDOI = prop.getProperty("openai.post_action");
            if (this.POSTACTIONCMDOI == null) {
                this.POSTACTIONCMDOI = " } - reply back with ";
            }
            this.NUMACTIONOI = prop.getProperty("openai.num_action");
            if (this.NUMACTIONOI == null) {
                this.NUMACTIONOI = " action only. Make sure Action matches exactly from this list";
            }
            this.METHODTOJSONOI = prop.getProperty("openai.method_to_json");
            if (this.METHODTOJSONOI == null) {
                this.METHODTOJSONOI = "- if you find the field named fieldValue, populate the field else and return the json as is";
            }
        }
        catch (IOException e) {
            log.warn(e.getMessage());
        }
    }

    private void initModelProp() {
        try (InputStream inputStream = PredictionLoader.class.getClassLoader().getResourceAsStream("tools4ai.properties");){
            if (inputStream == null) {
                log.error(" tools4ai properties not found ");
                return;
            }
            Properties prop = new Properties();
            prop.load(inputStream);
            this.projectId = prop.getProperty("gemini.projectId");
            if (this.projectId != null) {
                this.projectId = this.projectId.trim();
            }
            this.location = prop.getProperty("gemini.location");
            if (this.location != null) {
                this.location = this.location.trim();
            }
            this.modelName = prop.getProperty("gemini.modelName");
            if (this.modelName != null) {
                this.modelName = this.modelName.trim();
            }
            this.geminiVisionModelName = prop.getProperty("gemini.vision.modelName");
            if (this.geminiVisionModelName != null) {
                this.geminiVisionModelName = this.geminiVisionModelName.trim();
            }
            this.anthropicModelName = prop.getProperty("anthropic.modelName");
            this.anthropicLogReqFlag = Boolean.parseBoolean(prop.getProperty("anthropic.logRequests", "false"));
            this.anthropicLogResFlag = Boolean.parseBoolean(prop.getProperty("anthropic.logResponse", "false"));
            if (this.anthropicModelName != null) {
                this.anthropicModelName = this.anthropicModelName.trim();
            }
            this.openAiKey = prop.getProperty("openAiKey");
            if (this.openAiKey != null) {
                this.openAiKey = this.openAiKey.trim();
            }
            if (this.openAiKey == null || this.openAiKey.trim().isEmpty()) {
                this.openAiKey = System.getProperty("openAiKey");
            }
            if (this.claudeKey == null || this.claudeKey.trim().isEmpty()) {
                this.claudeKey = System.getProperty("claudeKey");
            }
            this.serperKey = prop.getProperty("serperKey");
            if (this.serperKey == null || this.serperKey.trim().isEmpty()) {
                this.serperKey = System.getProperty("serperKey");
            }
            if (this.serperKey != null) {
                this.serperKey = this.serperKey.trim();
            }
            log.debug("projectId: " + this.projectId);
            log.debug("location: " + this.location);
            log.debug("modelName: " + this.modelName);
            log.debug("serperKey: " + this.serperKey);
            log.debug("openAiKey: " + this.openAiKey);
            log.debug("claudeKey: " + this.claudeKey);
        }
        catch (IOException e) {
            log.warn(e.getMessage());
        }
    }

    public List<AIAction> getPredictedAction(String prompt, int num) throws AIProcessingException {
        GenerateContentResponse response;
        ArrayList<AIAction> actionList = new ArrayList<AIAction>();
        try {
            String groupName = ResponseHandler.getText((GenerateContentResponse)this.chatGroupFinder.sendMessage(" This is the prompt -" + prompt + " - which group does it belong " + this.actionGroupJson + " - just provide the group name and nothing else"));
            log.info(" will look in group " + groupName);
            String actionNameListTemp = this.getActionGroupList().getGroupActions().get(new ActionGroup(groupName).getGroupInfo());
            log.info(" list of actions " + actionNameListTemp);
            response = this.chat.sendMessage(this.buildPrompt(prompt, num, actionNameListTemp));
        }
        catch (IOException e) {
            throw new AIProcessingException(e);
        }
        String actionNameListStr = ResponseHandler.getText((GenerateContentResponse)response);
        String[] actionNames = actionNameListStr.split(",");
        if (actionNames.length <= 1) {
            actionNames = actionNameListStr.split("\n");
        }
        for (String actionName : actionNames) {
            actionName = actionName.trim();
            AIAction aiAction = this.getAiAction(actionName);
            actionList.add(aiAction);
        }
        return actionList;
    }

    public String getCommaSeparatedKeys(Map<String, ?> map) {
        StringBuilder builder = new StringBuilder();
        for (String key : map.keySet()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(key);
        }
        return builder.toString();
    }

    public String getActionParams(AIAction action, String prompt, AIPlatform aiProvider, Map<String, Object> params) throws AIProcessingException {
        String OPEN_AIPRMT = "here is your prompt - prompt_str - here is you action- action_name(params_values) - what parameter should you pass to this function. give comma separated name=values only and nothing else";
        String prmpt = OPEN_AIPRMT.replace("prompt_str", prompt);
        prmpt = prmpt.replace("action_name", action.getActionName());
        String realParms = this.getCommaSeparatedKeys(params);
        prmpt = prmpt.replace("params_values", realParms);
        log.debug(prmpt);
        if (aiProvider == AIPlatform.OPENAI) {
            return this.openAiChatModel.generate(prmpt);
        }
        if (aiProvider == AIPlatform.ANTHROPIC) {
            return this.anthropicChatModel.generate(prmpt);
        }
        try {
            return ResponseHandler.getText((GenerateContentResponse)this.chatExplain.sendMessage(prmpt));
        }
        catch (IOException e) {
            throw new AIProcessingException(e);
        }
    }

    public Object[] getComplexActionParams(String prompt, Map<String, Object> params, Gson gson) {
        Object[] paramsRet = new Object[params.keySet().size()];
        int i = 0;
        for (String key : params.keySet()) {
            try {
                Object ret;
                Object value = params.get(key);
                String json = this.classToJson((Class)value);
                String response = this.openAiChatModel.generate(" here is you prompt { " + prompt + "} and here is your json " + json + " - fill the json with values and return");
                paramsRet[i] = ret = gson.fromJson(response, (Class)value);
                ++i;
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return paramsRet;
    }

    private String classToJson(Class<?> clazz) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
        mapper.acceptJsonFormatVisitor(clazz, (JsonFormatVisitorWrapper)visitor);
        JsonSchema jsonSchema = visitor.finalSchema();
        JsonNode propertiesNode = mapper.valueToTree((Object)jsonSchema).path("properties");
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)propertiesNode);
    }

    public String postActionProcessing(String prompt, String result) {
        return this.openAiChatModel.generate(prompt + " result " + result);
    }

    public AIAction getPredictedAction(String prompt, AIPlatform aiProvider) {
        int numRetries = 0;
        AIAction action = null;
        try {
            if (AIPlatform.GEMINI == aiProvider) {
                JsonUtils utils = new JsonUtils();
                String groupName = ResponseHandler.getText((GenerateContentResponse)this.chatGroupFinder.sendMessage(PRMPT + prompt + GRP + this.actionGroupJson + "} - which group does this prompt belong to? response back in this format with only one set {'groupName':'','explanation':''}"));
                log.info(groupName);
                groupName = utils.fetchGroupName(groupName);
                log.info(LOOK_FOR_ACTION_IN_THE_GROUP + groupName + OUT_OF + this.actionGroupJson);
                String actionNameListTemp = this.getActionGroupList().getGroupActions().get(new ActionGroup(groupName.trim()).getGroupInfo()).trim();
                log.info(" list of actions " + actionNameListTemp);
                GenerateContentResponse response = this.chat.sendMessage(this.buildPromptWithJsonResponse(prompt, 1, actionNameListTemp));
                String actionName = ResponseHandler.getText((GenerateContentResponse)response).trim();
                actionName = utils.fetchActionName(actionName);
                actionNameListTemp = "," + actionNameListTemp + ",";
                if (!actionNameListTemp.contains("," + actionName + ",")) {
                    response = this.chat.sendMessage("give me just the action name from this query { " + actionName + "}");
                    actionName = ResponseHandler.getText((GenerateContentResponse)response).trim();
                    if (actionNameListTemp.contains("," + actionName + ",")) {
                        log.info(" Got the name correct " + actionName);
                    } else {
                        int NUM_OF_RETRIES = 2;
                        while (numRetries++ < NUM_OF_RETRIES) {
                            log.debug(" got " + actionName + " Trying again " + numRetries);
                            response = this.chat.sendMessage(this.buildPrompt(prompt, 1, actionNameListTemp));
                            actionName = ResponseHandler.getText((GenerateContentResponse)response);
                            if (!actionNameListTemp.contains("," + actionName + ",")) continue;
                        }
                    }
                }
                log.debug(" Predicted action by AI is " + actionName);
                action = this.getAiAction(actionName);
            } else if (AIPlatform.OPENAI == aiProvider) {
                String actionName = this.getOpenAiActionName(prompt);
                action = this.getAiAction(actionName);
                if (action == null) {
                    actionName = this.openAiChatModel.generate("provide action name from this and nothing else - " + actionName);
                    action = this.getAiAction(actionName);
                }
                if (action == null) {
                    log.debug("action not since it was null found , trying again");
                    actionName = this.fetchActionNameFromList(actionName);
                    log.debug("Predicted action by AI is " + actionName);
                    action = this.getAiAction(actionName);
                }
            } else if (AIPlatform.ANTHROPIC == aiProvider) {
                String actionName = this.getAnthrpicActionName(prompt);
                action = this.getAiAction(actionName);
                if (action == null) {
                    actionName = this.anthropicChatModel.generate("provide action name from this and nothing else - " + actionName);
                    action = this.getAiAction(actionName);
                }
                if (action == null) {
                    log.debug("action not again found , trying again");
                    actionName = this.fetchActionNameFromList(actionName);
                    log.debug("Predicted action by AI is " + actionName);
                    action = this.getAiAction(actionName);
                }
            }
        }
        catch (Exception e) {
            log.error(" Please make sure actions are configured {} ", (Object)e.getMessage());
            log.error(" Details ", (Throwable)e);
            return null;
        }
        return action;
    }

    @NotNull
    private String getOpenAiActionName(String prompt) {
        String groupName = this.openAiChatModel.generate(PRMPT + prompt + GRP + this.actionGroupJson + "} - just provide the group name and nothing else");
        log.info(LOOK_FOR_ACTION_IN_THE_GROUP + groupName + OUT_OF + this.actionGroupJson);
        String actionNameListTemp = this.getActionGroupList().getGroupActions().get(new ActionGroup(groupName).getGroupInfo());
        String actionName = this.openAiChatModel.generate(this.buildPromptForOpenAI(prompt, 1, new StringBuilder(actionNameListTemp)));
        actionName = actionName.replace("()", "");
        return actionName;
    }

    @NotNull
    private String getAnthrpicActionName(String prompt) {
        String groupName = this.anthropicChatModel.generate(PRMPT + prompt + GRP + this.actionGroupJson + "} - just provide the group name and nothing else");
        log.info(LOOK_FOR_ACTION_IN_THE_GROUP + groupName + OUT_OF + this.actionGroupJson);
        String actionNameList = this.getActionGroupList().getGroupActions().get(new ActionGroup(groupName).getGroupInfo());
        String actionName = this.anthropicChatModel.generate(this.buildPromptForOpenAI(prompt, 1, new StringBuilder(actionNameList)));
        actionName = actionName.replace("()", "");
        return actionName;
    }

    public String fetchActionNameFromList(String actionName) {
        String[] namesArray = this.actionNameList.toString().split(",");
        String realName = null;
        for (String name : namesArray) {
            if (!name.equalsIgnoreCase(actionName)) continue;
            realName = name;
        }
        return realName;
    }

    public AIAction getPredictedAction(String prompt) {
        return this.getPredictedAction(prompt, AIPlatform.GEMINI);
    }

    public String getMultiStepResult(String json) throws AIProcessingException {
        GenerateContentResponse response;
        try {
            response = this.chatMulti.sendMessage("look at the json string - " + json + " -  provide the information inside json in plain english language which is understandable");
        }
        catch (IOException e) {
            throw new AIProcessingException(e);
        }
        String nlpans = ResponseHandler.getText((GenerateContentResponse)response);
        log.debug(nlpans);
        return nlpans;
    }

    public String getPredictedActionMultiStep(String prompt) throws AIProcessingException {
        GenerateContentResponse response;
        try {
            response = this.chatMulti.sendMessage(this.buildPromptMultiStep(prompt));
        }
        catch (IOException e) {
            throw new AIProcessingException(e);
        }
        String subprompts = ResponseHandler.getText((GenerateContentResponse)response);
        log.debug(subprompts);
        return subprompts;
    }

    public String explainAction(String prompt, String action) {
        GenerateContentResponse response = null;
        try {
            response = this.chatExplain.sendMessage("explain why this action " + action + " is appropriate for this command " + prompt + " out of all these actions " + this.actionNameList);
        }
        catch (IOException e) {
            log.warn(e.getMessage());
        }
        assert (response != null);
        return ResponseHandler.getText(response);
    }

    public AIAction getAiAction(String actionName) {
        log.debug(" Trying to load " + actionName);
        AIAction action = this.predictions.get(actionName);
        if (action != null) {
            if (action.getActionType() == ActionType.SHELL) {
                return action;
            }
            if (action.getActionType() == ActionType.HTTP) {
                if (action instanceof HttpPredictedAction) {
                    return action;
                }
                if (action.getActionType() == ActionType.EXTEND) {
                    return action;
                }
            }
        }
        return action;
    }

    public static PredictionLoader getInstance() {
        return PredictionLoader.getInstance(null);
    }

    public static PredictionLoader getInstance(ApplicationContext springContext) {
        if (predictionLoader == null) {
            predictionLoader = new PredictionLoader();
            predictionLoader.setSpringContext(springContext);
            predictionLoader.processCP();
            predictionLoader.loadShellCommands();
            predictionLoader.loadHttpCommands();
            predictionLoader.loadSwaggerHttpActions();
            predictionLoader.buildGroupInfo();
        }
        return predictionLoader;
    }

    private void buildGroupInfo() {
        Gson gson = new Gson();
        this.actionGroupJson = gson.toJson(this.getActionGroupList().getGroupInfo());
    }

    public void setSpringContext(ApplicationContext springContext) {
        this.springContext = springContext;
    }

    private void loadShellCommands() {
        ShellPredictionLoader shellLoader = new ShellPredictionLoader();
        try {
            shellLoader.load(this.predictions, this.actionNameList, this.actionGroupList);
        }
        catch (LoaderException e) {
            log.error(e.getMessage());
        }
    }

    private void loadSwaggerHttpActions() {
        SwaggerPredictionLoader httpLoader = new SwaggerPredictionLoader();
        try {
            httpLoader.load(this.predictions, this.actionNameList, this.actionGroupList);
        }
        catch (LoaderException e) {
            log.error(e.getMessage());
        }
    }

    private void loadHttpCommands() {
        HttpRestPredictionLoader httpLoader = new HttpRestPredictionLoader();
        try {
            httpLoader.load(this.predictions, this.actionNameList);
        }
        catch (LoaderException e) {
            log.error(e.getMessage());
        }
    }

    public void processCP() {
        Reflections reflections = new Reflections("", new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()});
        Set predict = reflections.getTypesAnnotatedWith(Agent.class);
        Set activateLoader = reflections.getTypesAnnotatedWith(ActivateLoader.class);
        this.loaderPredict(predict);
        this.loaderExtended(activateLoader);
    }

    private void loaderExtended(Set<Class<?>> loaderClasses) {
        loaderClasses.forEach(actionCLAZZ -> {
            try {
                if (ExtendedPredictionLoader.class.isAssignableFrom((Class<?>)actionCLAZZ)) {
                    log.debug("Class " + actionCLAZZ + " implements Loader");
                    this.loadFromLoader((Class<?>)actionCLAZZ);
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        });
    }

    private void loaderPredict(Set<Class<?>> loaderClasses) {
        loaderClasses.forEach(actionCLAZZ -> {
            try {
                if (AIAction.class.isAssignableFrom((Class<?>)actionCLAZZ)) {
                    log.debug("Class " + actionCLAZZ + " implements AIAction");
                    if (ExtendedPredictedAction.class.isAssignableFrom((Class<?>)actionCLAZZ)) {
                        log.error("You cannot predict extended option implement AIAction instead" + actionCLAZZ);
                    } else {
                        this.addAction((Class<?>)actionCLAZZ);
                    }
                } else {
                    List<Method> annoatatedMethods = this.getAnnotatedMethods((Class<?>)actionCLAZZ);
                    for (Method method : annoatatedMethods) {
                        this.annotated((Class<?>)actionCLAZZ, method);
                    }
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        });
    }

    private void annotated(Class<?> actionCLAZZ, Method method) throws AIProcessingException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        GenericJavaMethodAction action = new GenericJavaMethodAction(actionCLAZZ, method);
        this.addGenericJavaMethodAction(action);
    }

    private void loadFromLoader(Class<?> clazz) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ExtendedPredictionLoader instance = (ExtendedPredictionLoader)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        try {
            Map<String, ExtendedPredictedAction> extendedPredictOptionsMap = instance.getExtendedActions();
            for (String key : extendedPredictOptionsMap.keySet()) {
                log.debug(" names " + this.actionNameList);
                this.actionNameList.append(key).append(",");
                this.predictions.put(key, extendedPredictOptionsMap.get(key));
            }
        }
        catch (LoaderException e) {
            log.error(e.getMessage() + " for " + clazz.getName());
        }
    }

    public List<Method> getAnnotatedMethods(Class<?> clazz) {
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Action.class)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    private void addGenericJavaMethodAction(GenericJavaMethodAction action) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Object instance = null;
        if (this.springContext != null) {
            instance = this.springContext.getBean(action.getActionClass());
            log.debug(" instance from Spring " + instance);
        }
        if (instance == null) {
            instance = action.getActionClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        action.setActionInstance(instance);
        String actionName = action.getActionName();
        this.actionNameList.append(actionName).append(",");
        this.actionGroupList.addAction(action);
        this.predictions.put(actionName, action);
    }

    private void addAction(Class<?> clazz) throws AIProcessingException {
        AIAction instance = null;
        if (this.springContext != null) {
            instance = (AIAction)this.springContext.getBean(clazz);
            log.debug("got instance from Spring " + instance);
        }
        if (instance == null) {
            try {
                instance = (AIAction)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new AIProcessingException(e);
            }
            catch (IllegalAccessException e) {
                throw new AIProcessingException(e);
            }
            catch (InvocationTargetException e) {
                throw new AIProcessingException(e);
            }
            catch (NoSuchMethodException e) {
                throw new AIProcessingException(e);
            }
        }
        String actionName = instance.getActionName();
        this.actionNameList.append(actionName).append(",");
        this.actionGroupList.addAction(instance);
        this.predictions.put(actionName, instance);
    }

    public Map<String, AIAction> getPredictions() {
        return this.predictions;
    }

    public StringBuilder getActionNameList() {
        return this.actionNameList;
    }

    private String buildPrompt(String prompt, int number, String actionNameList) {
        String append = " action only. Make sure Action matches exactly from this list";
        if (number > 1) {
            append = " actions only, in comma seperated list without any additional special characters";
        }
        String query = "here is my prompt - { " + prompt + " }" + "- what action do you think we should take out of these  - {  " + actionNameList + " } - reply back with " + number + append;
        log.debug(query);
        return query;
    }

    private String buildPromptWithJsonResponse(String prompt, int number, String actionNameList) {
        String query = " this is your prompt {" + prompt + "} and these are your actionNames {" + actionNameList + "} reply back with just one action name in json format {'actionName':'','reasoning':''}";
        log.debug(query);
        log.debug(number + "");
        return query;
    }

    private String getModifiedActionName(StringBuilder stringBuffer) {
        String[] functionNames = stringBuffer.toString().split(",");
        StringBuilder modifiedString = new StringBuilder();
        for (String functionName : functionNames) {
            modifiedString.append(functionName).append("(),");
        }
        if (modifiedString.length() > 0) {
            modifiedString.setLength(modifiedString.length() - 1);
        }
        return modifiedString.toString();
    }

    private String buildPromptForOpenAI(String prompt, int number, StringBuilder actionNameList) {
        String append = this.NUMACTIONOI;
        if (number > 1) {
            append = " actions only, in comma seperated list without any additional special characters";
        }
        String query = this.PREACTIONCMDOI + prompt + this.ACTIONCMDOI + this.getModifiedActionName(actionNameList) + " " + this.POSTACTIONCMDOI + number + " " + append;
        log.debug(query);
        return query;
    }

    private String buildPromptMultiStep(String prompt) {
        return "break down this prompt into multiple logical prompts in this json format { prompt : [ { id:unique_id,subprompt:'',depend_on=id} ] }- " + prompt + " - just give JSON and dont put any characters ";
    }

    public ActionList getActionGroupList() {
        return this.actionGroupList;
    }

    public ChatSession getChat() {
        return this.chat;
    }

    public void setChat(ChatSession chat) {
        this.chat = chat;
    }

    public ChatSession getChatExplain() {
        return this.chatExplain;
    }

    public void setChatExplain(ChatSession chatExplain) {
        this.chatExplain = chatExplain;
    }

    public void setChatGroupFinder(ChatSession chatGroupFinder) {
        this.chatGroupFinder = chatGroupFinder;
    }

    public ChatSession getChatGroupFinder() {
        return this.chatGroupFinder;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getGeminiVisionModelName() {
        return this.geminiVisionModelName;
    }

    public ChatLanguageModel getAnthropicChatModel() {
        return this.anthropicChatModel;
    }

    public void setAnthropicChatModel(ChatLanguageModel anthropicChatModel) {
        this.anthropicChatModel = anthropicChatModel;
    }

    public void setOpenAiChatModel(ChatLanguageModel openAiChatModel) {
        this.openAiChatModel = openAiChatModel;
    }

    public ChatLanguageModel getOpenAiChatModel() {
        return this.openAiChatModel;
    }

    public String getSerperKey() {
        return this.serperKey;
    }
}

