/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.predict;

import com.t4a.action.shell.ShellPredictedAction;
import com.t4a.api.AIAction;
import com.t4a.api.ActionList;
import com.t4a.predict.LoaderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.yaml.snakeyaml.Yaml;

public class ShellPredictionLoader {
    private static final Logger log = Logger.getLogger(ShellPredictionLoader.class.getName());
    private String yamlFile = "shell_actions.yaml";
    private URL resourceUrl = null;

    public void load(Map<String, AIAction> predictions, StringBuilder actionNameList, ActionList listOfActions) throws LoaderException {
        try {
            this.loadYamlFile(predictions, actionNameList, listOfActions);
        }
        catch (URISyntaxException e) {
            throw new LoaderException(e);
        }
    }

    public void loadYamlFile(Map<String, AIAction> predictions, StringBuilder actionNameList, ActionList listOfActions) throws URISyntaxException {
        if (this.resourceUrl == null) {
            this.resourceUrl = ShellPredictionLoader.class.getClassLoader().getResource(this.yamlFile);
        }
        if (this.resourceUrl == null) {
            log.warning("File not found: " + this.yamlFile);
            return;
        }
        try (InputStream inputStream = this.resourceUrl.openStream();
             InputStreamReader reader = new InputStreamReader(inputStream);){
            Yaml yaml = new Yaml();
            Map data = (Map)yaml.load((Reader)reader);
            for (Map.Entry groupEntry : data.entrySet()) {
                List groupInfo = (List)groupEntry.getValue();
                for (Map group : groupInfo) {
                    String groupDescription = (String)group.get("description");
                    String groupName = (String)group.get("name");
                    log.info("Group Name: " + groupName);
                    log.info("Description: " + groupDescription);
                    List scripts = (List)group.get("scripts");
                    for (Map scriptInfo : scripts) {
                        String scriptName = (String)scriptInfo.get("scriptName");
                        String actionName = (String)scriptInfo.get("actionName");
                        String parameterNames = (String)scriptInfo.get("parameters");
                        String description = (String)scriptInfo.get("description");
                        ShellPredictedAction shellAction = new ShellPredictedAction();
                        shellAction.setActionName(actionName);
                        shellAction.setScriptPath(scriptName);
                        shellAction.setParameterNames(parameterNames);
                        shellAction.setDescription(description);
                        shellAction.setGroup(groupName);
                        shellAction.setGroupDescription(groupDescription);
                        actionNameList.append(actionName);
                        actionNameList.append(",");
                        predictions.put(actionName, shellAction);
                        listOfActions.addAction(shellAction);
                    }
                }
            }
        }
        catch (IOException e) {
            log.warning(e.getMessage());
        }
    }
}

