/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.processor;

import com.t4a.JsonUtils;
import com.t4a.api.AIAction;
import com.t4a.api.GenericJavaMethodAction;
import com.t4a.detect.ExplainDecision;
import com.t4a.detect.HumanInLoop;
import com.t4a.processor.AIProcessingException;
import com.t4a.processor.LoggingHumanDecision;
import com.t4a.processor.LogginggExplainDecision;

public interface AIProcessor {
    public Object processSingleAction(String var1, AIAction var2, HumanInLoop var3, ExplainDecision var4) throws AIProcessingException;

    public Object processSingleAction(String var1, HumanInLoop var2, ExplainDecision var3) throws AIProcessingException;

    public Object processSingleAction(String var1) throws AIProcessingException;

    public String query(String var1) throws AIProcessingException;

    default public String query(String question, String answer) throws AIProcessingException {
        return this.query(" this was my question { " + question + "} context - " + answer);
    }

    default public String query(String question, Object answerObj) throws AIProcessingException {
        String answer = JsonUtils.convertObjectToJson(answerObj);
        return this.query(" this was my question { " + question + "} context - " + answer);
    }

    default public String summarize(String prompt) throws AIProcessingException {
        return this.query(" Summarize this { " + prompt + "}");
    }

    default public Object processSingleAction(String promptText, Object actionInstance, String actionName) throws AIProcessingException {
        GenericJavaMethodAction action = new GenericJavaMethodAction(actionInstance, actionName);
        return this.processSingleAction(promptText, action, new LoggingHumanDecision(), new LogginggExplainDecision());
    }

    default public Object processSingleAction(String promptText, Object actionInstance) throws AIProcessingException {
        GenericJavaMethodAction action = new GenericJavaMethodAction(actionInstance);
        return this.processSingleAction(promptText, action, new LoggingHumanDecision(), new LogginggExplainDecision());
    }
}

