/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.processor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageHandler {
    private static final Logger log = LoggerFactory.getLogger(ImageHandler.class);

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] readImageFile(String url) throws IOException {
        try (InputStream inputStream = ImageHandler.createInputStream(url);){
            byte[] byArray;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputStream createInputStream(String url) throws IOException, URISyntaxException {
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return ImageHandler.createHttpInputStream(url);
        }
        File file = new File(new URI(url));
        return new FileInputStream(file);
    }

    private static InputStream createHttpInputStream(String url) throws IOException {
        URL urlObj = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            return connection.getInputStream();
        }
        throw new IOException("Error fetching file: " + responseCode);
    }
}

