/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.processor;

import com.google.gson.Gson;
import com.t4a.JsonUtils;
import com.t4a.api.AIAction;
import com.t4a.api.AIPlatform;
import com.t4a.api.ActionRisk;
import com.t4a.api.ActionType;
import com.t4a.api.JavaMethodAction;
import com.t4a.api.JavaMethodExecutor;
import com.t4a.api.JavaMethodInvoker;
import com.t4a.detect.ExplainDecision;
import com.t4a.detect.HumanInLoop;
import com.t4a.predict.PredictionLoader;
import com.t4a.processor.AIProcessingException;
import com.t4a.processor.AIProcessor;
import com.t4a.processor.LoggingHumanDecision;
import com.t4a.processor.LogginggExplainDecision;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAiActionProcessor
implements AIProcessor {
    private static final Logger log = LoggerFactory.getLogger(OpenAiActionProcessor.class);
    private Gson gson;

    public OpenAiActionProcessor(Gson gson) {
        this.gson = gson;
    }

    @Override
    public String query(String promptText) throws AIProcessingException {
        return PredictionLoader.getInstance().getOpenAiChatModel().generate(promptText);
    }

    public OpenAiActionProcessor() {
        this.gson = new Gson();
    }

    @Override
    public Object processSingleAction(String promptText, HumanInLoop humanVerification, ExplainDecision explain) throws AIProcessingException {
        return this.processSingleAction(promptText, null, humanVerification, explain);
    }

    public Object processSingleAction(String promptText, AIAction action) throws AIProcessingException {
        return this.processSingleAction(promptText, action, null, null);
    }

    public Object processSingleAction(String promptText, String actionName) throws AIProcessingException {
        AIAction action = PredictionLoader.getInstance().getAiAction(actionName);
        if (action == null) {
            throw new AIProcessingException(" action not found " + actionName);
        }
        return this.processSingleAction(promptText, action, null, null);
    }

    @Override
    public Object processSingleAction(String prompt, AIAction action, HumanInLoop humanVerification, ExplainDecision explain) throws AIProcessingException {
        if (action == null && (action = PredictionLoader.getInstance().getPredictedAction(prompt, AIPlatform.OPENAI)).getActionRisk() == ActionRisk.HIGH) {
            log.warn(" This is a high risk action needs to be explicitly provided by human operator cannot be predicted by AI " + action.getActionName());
            return "This is a high risk action will not proceed " + action.getActionName();
        }
        if (action.getActionType() == ActionType.JAVAMETHOD) {
            Object result;
            Method method;
            Method[] methods;
            log.debug(action + "");
            JsonUtils utils = new JsonUtils();
            Method m = null;
            JavaMethodAction javaMethodAction = (JavaMethodAction)action;
            Class<?> clazz = javaMethodAction.getActionClass();
            for (Method m1 : methods = clazz.getMethods()) {
                if (!m1.getName().equals(javaMethodAction.getActionName())) continue;
                m = m1;
                break;
            }
            if (m == null) {
                throw new AIProcessingException("Method name should matches the actionName  " + action.getActionName() + " class " + action.getClass().getName());
            }
            String jsonStr = utils.convertMethodTOJsonString(m);
            try {
                jsonStr = PredictionLoader.getInstance().getOpenAiChatModel().generate(" Here is your prompt {" + prompt + "} - here is the json - " + jsonStr + " " + PredictionLoader.getInstance().METHODTOJSONOI);
            }
            catch (Exception e) {
                throw new AIProcessingException(" Make sure openAiKey is set either in tools4Ai.properties or as runtime parameter -DopenAiKey=");
            }
            log.info(jsonStr);
            JavaMethodInvoker invoke = new JavaMethodInvoker();
            Object[] obj = invoke.parse(jsonStr);
            List parameterValues = (List)obj[1];
            List parameterTypes = (List)obj[0];
            try {
                method = clazz.getMethod(m.getName(), parameterTypes.toArray(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new AIProcessingException(e);
            }
            try {
                result = method.invoke(javaMethodAction.getActionInstance(), parameterValues.toArray());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AIProcessingException(e);
            }
            return result;
        }
        log.debug(action + "");
        JavaMethodExecutor methodExecutor = new JavaMethodExecutor();
        methodExecutor.mapMethod(action);
        log.debug(methodExecutor.getProperties() + "");
        String params = PredictionLoader.getInstance().getActionParams(action, prompt, AIPlatform.OPENAI, methodExecutor.getProperties());
        Object obj = null;
        try {
            if (humanVerification.allow(prompt, action.getActionName(), params).isAIResponseValid()) {
                obj = methodExecutor.action(params, action);
                log.debug(" the action is returning " + obj);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AIProcessingException(e);
        }
        return obj;
    }

    public Object processSingleNonJava(String prompt, AIAction action, HumanInLoop humanVerification, ExplainDecision explain) throws AIProcessingException {
        if (action == null) {
            action = PredictionLoader.getInstance().getPredictedAction(prompt, AIPlatform.OPENAI);
        }
        log.debug(action + "");
        JavaMethodExecutor methodExecutor = new JavaMethodExecutor();
        methodExecutor.mapMethod(action);
        Object objReturnFromAI = null;
        if (action.getActionType() == ActionType.JAVAMETHOD) {
            if (((JavaMethodAction)action).isComplexMethod()) {
                Object[] params = PredictionLoader.getInstance().getComplexActionParams(prompt, methodExecutor.getProperties(), this.gson);
                objReturnFromAI = methodExecutor.action(params, action);
                log.debug(" the action returned " + objReturnFromAI);
            } else {
                log.debug(methodExecutor.getProperties() + "");
                String params = PredictionLoader.getInstance().getActionParams(action, prompt, AIPlatform.OPENAI, methodExecutor.getProperties());
                try {
                    if (humanVerification.allow(prompt, action.getActionName(), params).isAIResponseValid()) {
                        objReturnFromAI = methodExecutor.action(params, action);
                        log.debug(" the action returned " + objReturnFromAI);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new AIProcessingException(e);
                }
            }
        }
        return PredictionLoader.getInstance().postActionProcessing(prompt, (String)objReturnFromAI);
    }

    @Override
    public Object processSingleAction(String prompt) throws AIProcessingException {
        return this.processSingleAction(prompt, new LoggingHumanDecision(), new LogginggExplainDecision());
    }
}

