/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.processor.scripts;

import com.google.gson.Gson;
import com.t4a.processor.AIProcessingException;
import com.t4a.processor.scripts.LoggingSeleniumCallback;
import com.t4a.processor.scripts.ScriptResult;
import com.t4a.processor.scripts.SeleniumCallback;
import com.t4a.processor.selenium.SeleniumGeminiProcessor;
import com.t4a.processor.selenium.SeleniumProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumScriptProcessor {
    private static final Logger log = LoggerFactory.getLogger(SeleniumScriptProcessor.class);
    private Gson gson;
    private SeleniumProcessor actionProcessor;

    public SeleniumScriptProcessor() {
        this.gson = new Gson();
        this.actionProcessor = new SeleniumGeminiProcessor();
    }

    public SeleniumScriptProcessor(Gson gson) {
        this.gson = gson;
    }

    public SeleniumScriptProcessor(Gson gson, SeleniumProcessor actionProcessor) {
        this.gson = gson;
        this.actionProcessor = actionProcessor;
    }

    public SeleniumScriptProcessor(SeleniumProcessor actionProcessor) {
        this.gson = new Gson();
        this.actionProcessor = actionProcessor;
    }

    public ScriptResult process(String fileName) {
        return this.process(fileName, new LoggingSeleniumCallback());
    }

    public ScriptResult process(String fileName, SeleniumCallback callback) {
        ScriptResult result = new ScriptResult();
        try (InputStream is = SeleniumScriptProcessor.class.getClassLoader().getResourceAsStream(fileName);
             BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            log.debug("Processing script file: " + fileName);
            this.processCommands(reader, result, callback);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        catch (NullPointerException e) {
            log.info("Resource file not found. Make sure the file path is correct.");
        }
        catch (AIProcessingException e) {
            log.error(e.getMessage());
        }
        return result;
    }

    public void processCommands(BufferedReader reader, ScriptResult result, SeleniumCallback callback) throws IOException, AIProcessingException {
        String line;
        SeleniumProcessor processor = this.getActionProcessor();
        while ((line = reader.readLine()) != null) {
            callback.beforeWebAction(processor.getDriver());
            processor.processWebAction(line);
            callback.afterWebAction(processor.getDriver());
            log.debug("{}", (Object)result);
        }
    }

    public Gson getGson() {
        return this.gson;
    }

    public SeleniumProcessor getActionProcessor() {
        return this.actionProcessor;
    }
}

