/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.transform;

import com.google.cloud.vertexai.VertexAI;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.generativeai.ResponseHandler;
import com.google.gson.Gson;
import com.t4a.JsonUtils;
import com.t4a.predict.PredictionLoader;
import com.t4a.processor.AIProcessingException;
import com.t4a.transform.PromptTransformer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiV2PromptTransformer
implements PromptTransformer {
    private static final Logger log = LoggerFactory.getLogger(GeminiV2PromptTransformer.class);
    Gson gson;

    public GeminiV2PromptTransformer(Gson gson) {
        this.gson = gson;
    }

    public GeminiV2PromptTransformer() {
        this.gson = new Gson();
    }

    public Gson getGson() {
        return this.gson;
    }

    @Override
    public String getJSONResponseFromAI(String prompt, String jsonStr) throws AIProcessingException {
        try {
            return ResponseHandler.getText((GenerateContentResponse)PredictionLoader.getInstance().getChatExplain().sendMessage(" Here is your prompt {" + prompt + "} - here is the json - " + jsonStr + " - populate the fieldValue and return the json"));
        }
        catch (IOException e) {
            throw new AIProcessingException(e);
        }
    }

    public String transformIntoJsonWithValues(String promptText, String ... name) throws AIProcessingException {
        JsonUtils utils = new JsonUtils();
        return this.transformIntoJson(utils.createJson(name), promptText, "get me values", "Get me the values in json");
    }

    @Override
    public String transformIntoJson(String jsonString, String promptText, String funName, String description) throws AIProcessingException {
        String string;
        VertexAI vertexAI = new VertexAI(PredictionLoader.getInstance().getProjectId(), PredictionLoader.getInstance().getLocation());
        try {
            string = ResponseHandler.getText((GenerateContentResponse)PredictionLoader.getInstance().getChatExplain().sendMessage(" Here is your prompt {" + promptText + "} - here is the json - " + jsonString + " - populate the fieldValue and return the json"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    vertexAI.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AIProcessingException(e);
            }
        }
        vertexAI.close();
        return string;
    }
}

