/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.api;

import com.t4a.api.AIAction;
import com.t4a.api.ActionKey;
import com.t4a.api.GroupInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ActionGroup {
    private List<ActionKey> actions = new ArrayList<ActionKey>();
    private GroupInfo groupInfo = new GroupInfo();

    public ActionGroup(String groupName) {
        this.groupInfo.setGroupName(groupName);
        this.groupInfo.setGroupDescription("");
    }

    public ActionGroup(String groupName, String groupDescription) {
        this.groupInfo.setGroupName(groupName);
        this.groupInfo.setGroupDescription(groupDescription);
    }

    public void addAction(ActionKey key) {
        this.actions.add(key);
    }

    public void addAction(AIAction action) {
        this.actions.add(new ActionKey(action));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionGroup that = (ActionGroup)o;
        return Objects.equals(this.groupInfo, that.groupInfo);
    }

    public int hashCode() {
        return Objects.hash(this.groupInfo);
    }

    public List<ActionKey> getActions() {
        return this.actions;
    }

    public GroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    public void setActions(List<ActionKey> actions) {
        this.actions = actions;
    }

    public void setGroupInfo(GroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    public ActionGroup() {
    }

    public ActionGroup(List<ActionKey> actions, GroupInfo groupInfo) {
        this.actions = actions;
        this.groupInfo = groupInfo;
    }
}

