/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.api;

import com.google.cloud.vertexai.api.FunctionDeclaration;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.Type;
import com.google.gson.Gson;
import com.t4a.action.ExtendedInputParameter;
import com.t4a.action.ExtendedPredictedAction;
import com.t4a.action.http.HttpPredictedAction;
import com.t4a.action.http.InputParameter;
import com.t4a.action.shell.ShellPredictedAction;
import com.t4a.api.AIAction;
import com.t4a.api.ActionType;
import com.t4a.api.GenericJavaMethodAction;
import com.t4a.api.JavaActionExecutor;
import com.t4a.api.JavaMethodAction;
import com.t4a.predict.LoaderException;
import com.t4a.processor.AIProcessingException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaMethodExecutor
extends JavaActionExecutor {
    private static final Logger log = LoggerFactory.getLogger(JavaMethodExecutor.class);
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private FunctionDeclaration generatedFunction;
    private Gson gson = new Gson();
    private Class<?> clazz;
    private Method method;
    private AIAction action;

    public JavaMethodExecutor() {
    }

    public JavaMethodExecutor(Gson gson) {
        if (gson != null) {
            this.gson = gson;
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public FunctionDeclaration getGeneratedFunction() {
        return this.generatedFunction;
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    private FunctionDeclaration buildFunction(String className, String methodName, String funName, String discription) {
        this.mapMethod(className, methodName);
        this.generatedFunction = this.getBuildFunction(funName, discription);
        return this.generatedFunction;
    }

    private FunctionDeclaration buildFunction(HttpPredictedAction action, String funName, String discription) {
        if (action.isHasJson()) {
            if (discription == null) {
                discription = funName;
            }
            this.generatedFunction = this.getBuildFunction(action.getJsonMap(), funName, discription);
        } else {
            this.mapMethod(action);
            if (discription == null) {
                discription = funName;
            }
            this.generatedFunction = this.getBuildFunction(funName, discription);
        }
        return this.generatedFunction;
    }

    private FunctionDeclaration buildFunction(ExtendedPredictedAction action, String funName, String discription) {
        this.mapMethod(action);
        this.generatedFunction = this.getBuildFunction(funName, discription);
        return this.generatedFunction;
    }

    private FunctionDeclaration buildFunction(ShellPredictedAction action, String funName, String discription) {
        this.mapMethod(action);
        this.generatedFunction = this.getBuildFunction(funName, discription);
        return this.generatedFunction;
    }

    public FunctionDeclaration buildFunction(Object actionInstance, String actionName) throws AIProcessingException {
        GenericJavaMethodAction gjvm = new GenericJavaMethodAction(actionInstance, actionName);
        return this.buildFunction(gjvm);
    }

    public FunctionDeclaration buildFunction(AIAction action) throws AIProcessingException {
        this.action = action;
        if (action.getActionType().equals((Object)ActionType.SHELL)) {
            ShellPredictedAction shellAction = (ShellPredictedAction)action;
            return this.buildFunction(shellAction, action.getActionName(), action.getDescription());
        }
        if (action.getActionType().equals((Object)ActionType.HTTP)) {
            HttpPredictedAction httpAction = (HttpPredictedAction)action;
            return this.buildFunction(httpAction, httpAction.getActionName(), httpAction.getDescription());
        }
        if (action.getActionType().equals((Object)ActionType.EXTEND)) {
            ExtendedPredictedAction extendedPredictedAction = (ExtendedPredictedAction)action;
            return this.buildFunction(extendedPredictedAction, extendedPredictedAction.getActionName(), extendedPredictedAction.getDescription());
        }
        if (action.getActionType().equals((Object)ActionType.JAVAMETHOD)) {
            JavaMethodAction methodAction = (JavaMethodAction)action;
            if (!methodAction.isComplexMethod()) {
                return this.buildFunction(methodAction.getActionClassName(), action.getActionName(), action.getActionName(), action.getDescription());
            }
            log.warn("method has pojos or complex data type , Will try to convert them, if it fails  please use GeminiPromptTransformer");
            return this.buildFunction(methodAction.getActionClassName(), action.getActionName(), action.getActionName(), action.getDescription());
        }
        return this.buildFunction(action.getClass().getName(), action.getActionName(), action.getActionName(), action.getDescription());
    }

    public void mapMethod(AIAction action) {
        this.action = action;
        if (action.getActionType().equals((Object)ActionType.SHELL)) {
            this.mapShellMethod((ShellPredictedAction)action);
        } else if (action.getActionType().equals((Object)ActionType.HTTP)) {
            this.mapHttpMethod((HttpPredictedAction)action);
        } else if (action.getActionType().equals((Object)ActionType.EXTEND)) {
            this.mapExtendedMethod((ExtendedPredictedAction)action);
        } else if (action.getActionType().equals((Object)ActionType.JAVAMETHOD)) {
            if (action instanceof GenericJavaMethodAction) {
                this.mapMethod(((GenericJavaMethodAction)action).getActionClassName(), ((GenericJavaMethodAction)action).getActionName());
            } else {
                this.mapMethod(action.getClass().getName(), action.getActionName());
            }
        }
    }

    private void mapHttpMethod(HttpPredictedAction action) {
        if (action.isHasJson()) {
            Map<String, Object> map = action.getJsonMap();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.properties.put(entry.getKey(), this.mapType(entry.getValue().getClass()));
            }
        } else {
            List<InputParameter> inputParameterList = action.getInputObjects();
            for (InputParameter parameter : inputParameterList) {
                if (parameter.hasDefaultValue()) continue;
                this.properties.put(parameter.getName(), this.mapType(parameter.getType()));
            }
        }
    }

    private void mapExtendedMethod(ExtendedPredictedAction action) {
        List<ExtendedInputParameter> inputParameterList = action.getInputParameters();
        for (ExtendedInputParameter parameter : inputParameterList) {
            if (parameter.hasDefaultValue()) continue;
            this.properties.put(parameter.getName(), this.mapType(parameter.getType()));
        }
    }

    private void mapShellMethod(ShellPredictedAction action) {
        String[] names;
        for (String name : names = action.getParameterNames().split(",")) {
            this.properties.put(name, this.mapType("String"));
        }
    }

    private void mapMethod(String className, String methodName) {
        try {
            Method[] methods;
            this.clazz = Class.forName(className);
            for (Method method : methods = this.clazz.getMethods()) {
                Parameter[] parameters;
                if (!method.getName().equals(methodName)) continue;
                this.method = method;
                for (Parameter parameter : parameters = method.getParameters()) {
                    Type tp = this.mapType(parameter.getType());
                    this.properties.put(parameter.getName(), tp == Type.OBJECT ? parameter.getType() : tp);
                }
                return;
            }
            log.error("Method not found: " + methodName);
        }
        catch (ClassNotFoundException e) {
            log.error("Class not found: " + className);
        }
    }

    public Object action(GenerateContentResponse response, Object actionInstance, String actionName) throws AIProcessingException, InvocationTargetException, IllegalAccessException {
        GenericJavaMethodAction gjvm = new GenericJavaMethodAction(actionInstance, actionName);
        return this.action(response, (AIAction)gjvm);
    }

    public AIAction getAction() {
        return this.action;
    }

    public Object action(GenerateContentResponse response, AIAction instance) throws InvocationTargetException, IllegalAccessException {
        Map<String, Object> propertyValuesMap = this.getPropertyValuesMap(response);
        if (instance.getActionType().equals((Object)ActionType.HTTP)) {
            HttpPredictedAction action = (HttpPredictedAction)instance;
            if (propertyValuesMap.keySet().size() < 1) {
                propertyValuesMap = this.getPropertyValuesMapMap(response);
            }
            try {
                return action.executeHttpRequest(propertyValuesMap);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (instance.getActionType().equals((Object)ActionType.SHELL)) {
            ShellPredictedAction action = (ShellPredictedAction)instance;
            try {
                String paramNamesStr = action.getParameterNames();
                String[] paramNamesArray = paramNamesStr.split(",");
                String[] paraNamesToPassToShell = new String[paramNamesArray.length];
                for (int i = 0; i < paramNamesArray.length; ++i) {
                    String s = paramNamesArray[i];
                    paramNamesArray[i] = (String)propertyValuesMap.get(s);
                    log.debug(paramNamesArray[i]);
                }
                action.executeShell(paramNamesArray);
                return "Executed " + action.getActionName();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        if (instance.getActionType().equals((Object)ActionType.EXTEND)) {
            ExtendedPredictedAction action = (ExtendedPredictedAction)instance;
            try {
                return action.extendedExecute(propertyValuesMap);
            }
            catch (LoaderException e) {
                throw new RuntimeException(e);
            }
        }
        Parameter[] parametersFromMethod = this.method.getParameters();
        Object[] parameterValues = new Object[parametersFromMethod.length];
        for (int i = 0; i < parametersFromMethod.length; ++i) {
            if (this.mapType(parametersFromMethod[i].getType()) == Type.OBJECT) {
                log.debug(parametersFromMethod[i].getType() + "");
                parameterValues[i] = this.getGson().fromJson(this.getGson().toJson(this.getPropertyValuesMapMap(response).get(parametersFromMethod[i].getName())), parametersFromMethod[i].getType());
                log.debug("created " + parameterValues[i].toString());
                continue;
            }
            parameterValues[i] = propertyValuesMap.get(parametersFromMethod[i].getName());
        }
        Object obj = null;
        try {
            obj = this.method.invoke(((JavaMethodAction)instance).getActionInstance(), parameterValues);
        }
        catch (Exception e) {
            log.warn("could not invoke method returning values " + e.getMessage());
        }
        if (obj == null) {
            obj = "{failed}";
        }
        return obj;
    }

    public Object action(Object[] params, AIAction instance) {
        Object obj = null;
        try {
            obj = this.method.invoke((Object)instance, params);
        }
        catch (Exception e) {
            log.warn("could not invoke method returning values" + e.getMessage());
        }
        if (obj == null) {
            obj = "{failed}";
        }
        return obj;
    }

    public Object action(String params, AIAction instance) throws InvocationTargetException, IllegalAccessException {
        Map<String, Object> propertyValuesMap = this.getPropertyValuesMap(params);
        if (instance.getActionType().equals((Object)ActionType.HTTP)) {
            HttpPredictedAction action = (HttpPredictedAction)instance;
            try {
                return action.executeHttpRequest(propertyValuesMap);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (instance.getActionType().equals((Object)ActionType.SHELL)) {
            ShellPredictedAction action = (ShellPredictedAction)instance;
            try {
                String paramNamesStr = action.getParameterNames();
                String[] paramNamesArray = paramNamesStr.split(",");
                String[] paraNamesToPassToShell = new String[paramNamesArray.length];
                for (int i = 0; i < paramNamesArray.length; ++i) {
                    String s = paramNamesArray[i];
                    paramNamesArray[i] = (String)propertyValuesMap.get(s);
                    log.debug(paramNamesArray[i]);
                }
                action.executeShell(paramNamesArray);
                return "Executed " + action.getActionName();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        if (instance.getActionType().equals((Object)ActionType.EXTEND)) {
            ExtendedPredictedAction action = (ExtendedPredictedAction)instance;
            try {
                return action.extendedExecute(propertyValuesMap);
            }
            catch (LoaderException e) {
                throw new RuntimeException(e);
            }
        }
        String[] parameterNames = (String[])Arrays.stream(this.method.getParameters()).map(p -> p.getName()).toArray(String[]::new);
        Object[] parameterValues = new Object[parameterNames.length];
        for (int i = 0; i < parameterNames.length; ++i) {
            parameterValues[i] = propertyValuesMap.get(parameterNames[i]);
        }
        Object obj = null;
        try {
            obj = this.method.invoke((Object)instance, parameterValues);
        }
        catch (Exception e) {
            log.warn("could not invoke method returning values" + e.getMessage());
        }
        if (obj == null) {
            obj = "{failed}";
        }
        return obj;
    }
}

