/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.predict;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.t4a.action.http.HttpMethod;
import com.t4a.action.http.HttpPredictedAction;
import com.t4a.action.http.InputParameter;
import com.t4a.api.AIAction;
import com.t4a.predict.LoaderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;

public class HttpRestPredictionLoader {
    private static final Logger log = Logger.getLogger(HttpRestPredictionLoader.class.getName());
    private String yamlFile = "http_actions.json";
    private URL resourceUrl = null;

    public void load(Map<String, AIAction> predictions, StringBuilder actionNameList) throws LoaderException {
        try {
            this.parseConfig(predictions, actionNameList);
        }
        catch (IOException e) {
            throw new LoaderException(e);
        }
    }

    public void parseConfig(Map<String, AIAction> predictions, StringBuilder actionNameList) throws IOException {
        if (this.resourceUrl == null) {
            this.resourceUrl = HttpRestPredictionLoader.class.getClassLoader().getResource(this.yamlFile);
        }
        if (this.resourceUrl == null) {
            log.warning("File not found: " + this.yamlFile);
            return;
        }
        Gson gson = new Gson();
        try (InputStream inputStream = this.resourceUrl.openStream();
             InputStreamReader reader = new InputStreamReader(inputStream);){
            JsonObject rootObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            JsonArray endpoints = rootObject.getAsJsonArray("endpoints");
            for (JsonElement obj : endpoints) {
                JsonObject endpoint = obj.getAsJsonObject();
                String actionName = endpoint.get("actionName").getAsString();
                String url = endpoint.get("url").getAsString();
                String type = endpoint.get("type").getAsString();
                String description = endpoint.get("description").getAsString();
                ArrayList<InputParameter> inputObjects = new ArrayList<InputParameter>();
                JsonArray inputArray = endpoint.getAsJsonArray("input_object");
                for (JsonElement inputElement : inputArray) {
                    JsonObject inputObj = inputElement.getAsJsonObject();
                    String inputname = inputObj.get("name").getAsString();
                    String inputType = inputObj.get("type").getAsString();
                    String inputDescription = inputObj.get("description").getAsString();
                    JsonElement defaultValue = inputObj.get("defaultValue");
                    InputParameter parameter = new InputParameter(inputname, inputType, inputDescription);
                    if (defaultValue != null) {
                        parameter.setDefaultValue(defaultValue.toString());
                    }
                    inputObjects.add(parameter);
                }
                JsonObject outputObject = endpoint.getAsJsonObject("output_object");
                JsonObject authInterface = endpoint.getAsJsonObject("auth_interface");
                HttpPredictedAction httpPredictedAction = new HttpPredictedAction();
                httpPredictedAction.setDescription(description);
                httpPredictedAction.setUrl(url);
                httpPredictedAction.setType(HttpMethod.valueOf(type));
                httpPredictedAction.setAuthInterface(authInterface);
                httpPredictedAction.setInputObjects(inputObjects);
                httpPredictedAction.setOutputObject(outputObject);
                actionNameList.append(actionName);
                actionNameList.append(", ");
                predictions.put(actionName, httpPredictedAction);
            }
        }
    }
}

