/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.predict;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.t4a.JsonUtils;
import com.t4a.action.http.HttpMethod;
import com.t4a.action.http.HttpPredictedAction;
import com.t4a.action.http.InputParameter;
import com.t4a.action.http.ParamLocation;
import com.t4a.api.AIAction;
import com.t4a.api.ActionList;
import com.t4a.predict.LoaderException;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.converter.SwaggerConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerPredictionLoader {
    private static final Logger log = LoggerFactory.getLogger(SwaggerPredictionLoader.class);
    private String yamlFile = "swagger_actions.json";
    private URL resourceUrl = null;

    public void load(Map<String, AIAction> predictions, StringBuilder actionNameList, ActionList listOfActions) throws LoaderException {
        try {
            this.parseConfig(predictions, actionNameList, listOfActions);
        }
        catch (IOException e) {
            throw new LoaderException(e);
        }
    }

    public void parseConfig(Map<String, AIAction> predictions, StringBuilder actionNameList, ActionList listOfActions) throws IOException {
        if (this.resourceUrl == null) {
            this.resourceUrl = SwaggerPredictionLoader.class.getClassLoader().getResource(this.yamlFile);
        }
        if (this.resourceUrl == null) {
            log.info("File not found: " + this.yamlFile);
            return;
        }
        Gson gson = new Gson();
        try (InputStream inputStream = this.resourceUrl.openStream();
             InputStreamReader reader = new InputStreamReader(inputStream);){
            JsonObject rootObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            JsonArray endpoints = rootObject.getAsJsonArray("endpoints");
            for (JsonElement obj : endpoints) {
                JsonObject endpoint = obj.getAsJsonObject();
                String swaggerurl = endpoint.get("swaggerurl").getAsString();
                String group = endpoint.get("group").getAsString();
                String groupDiscription = endpoint.get("description").getAsString();
                if (group == null) {
                    group = "default";
                    groupDiscription = "default";
                }
                String id = endpoint.get("id").getAsString();
                String baseurl = endpoint.get("baseurl").getAsString();
                JsonArray headersArray = endpoint.getAsJsonArray("headers");
                HashMap<String, String> headers = new HashMap<String, String>();
                if (headersArray != null) {
                    for (JsonElement headerElement : headersArray) {
                        JsonObject headerObj = headerElement.getAsJsonObject();
                        String key = headerObj.get("key").getAsString();
                        String value = headerObj.get("value").getAsString();
                        headers.put(key, value);
                    }
                }
                this.loadURL(swaggerurl, predictions, actionNameList, baseurl, headers, group, groupDiscription, listOfActions);
            }
        }
    }

    public void loadURL(String jsonURL, Map<String, AIAction> predictions, StringBuilder actionNameList, String baseURL, Map<String, String> headers, String group, String groupDiscription, ActionList listOfActions) {
        try {
            boolean swagger2 = false;
            OpenAPI openAPI = new OpenAPIV3Parser().readLocation(jsonURL, null, null).getOpenAPI();
            if (openAPI == null) {
                openAPI = new SwaggerConverter().readLocation(jsonURL, null, null).getOpenAPI();
                swagger2 = true;
            }
            Paths paths = openAPI.getPaths();
            for (Map.Entry entry : paths.entrySet()) {
                String path = (String)entry.getKey();
                PathItem pathItem = (PathItem)entry.getValue();
                for (Map.Entry operationEntry : pathItem.readOperationsMap().entrySet()) {
                    PathItem.HttpMethod method = (PathItem.HttpMethod)operationEntry.getKey();
                    Operation operation = (Operation)operationEntry.getValue();
                    HttpPredictedAction httpAction = new HttpPredictedAction();
                    httpAction.setGroup(group);
                    httpAction.setGroupDescription(groupDiscription);
                    String actionName = operation.getOperationId();
                    if (actionName == null || actionName.trim().equals("")) {
                        String[] segments = path.split("/");
                        String resourceNameQ = segments[segments.length - 1];
                        Object resourceName = resourceNameQ.split("[{?]")[0];
                        if (resourceName == null || ((String)resourceName).trim().equals("")) {
                            int index;
                            String[] tryAgainSeg = path.split("/");
                            for (index = segments.length - 1; index >= 0 && tryAgainSeg[index].contains("{"); --index) {
                            }
                            resourceName = tryAgainSeg[index];
                        }
                        actionName = method.name().toLowerCase() + (String)resourceName;
                    }
                    httpAction.setActionName(actionName);
                    httpAction.setHeaders(headers);
                    httpAction.setUrl(baseURL + path);
                    httpAction.setType(HttpMethod.valueOf(method.name()));
                    ArrayList<InputParameter> inputParameters = new ArrayList<InputParameter>();
                    InputParameter inputParameter = null;
                    if (operation.getParameters() != null) {
                        for (Parameter parameter : operation.getParameters()) {
                            String paraName = parameter.getName();
                            if (paraName == null && swagger2) {
                                paraName = parameter.get$ref().substring(parameter.get$ref().lastIndexOf("/") + 1);
                                parameter = (Parameter)openAPI.getComponents().getParameters().get(paraName);
                            }
                            String paraType = parameter.getSchema().getType();
                            inputParameter = new InputParameter(paraName, paraType, "");
                            if ("query".equals(parameter.getIn())) {
                                inputParameter.setLocation(ParamLocation.QUERY);
                                continue;
                            }
                            if (!path.contains("{" + paraName + "}")) continue;
                            inputParameter.setLocation(ParamLocation.PATH);
                        }
                    } else if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null) {
                        inputParameter = new InputParameter();
                        RequestBody requestBody = operation.getRequestBody();
                        if (requestBody != null && requestBody.getContent() != null) {
                            for (MediaType mediaType : requestBody.getContent().values()) {
                                if (mediaType.getSchema() == null) continue;
                                if (mediaType.getSchema().get$ref() != null) {
                                    JsonUtils utils = new JsonUtils();
                                    String jsonString = utils.convertClassObjectToJsonString(SwaggerPredictionLoader.resolveSchema(openAPI, mediaType.getSchema().get$ref()));
                                    ObjectMapper objectMapper = new ObjectMapper();
                                    Map map = (Map)objectMapper.readValue(jsonString, Map.class);
                                    httpAction.setRequestBodyJson(jsonString);
                                    httpAction.setJsonMap(map);
                                    httpAction.setHasJson(true);
                                    continue;
                                }
                                log.debug("Schema not found for " + actionName + " " + jsonURL);
                            }
                        }
                    } else {
                        log.debug("nothing found for {} ,  it could be direct call without parameters ", (Object)actionName);
                    }
                    if (inputParameter != null) {
                        inputParameters.add(inputParameter);
                    }
                    httpAction.setInputObjects(inputParameters);
                    if (predictions.containsKey(actionName)) {
                        log.debug("action is present {} ", (Object)actionName);
                        actionName = this.getModifiedActionName(httpAction);
                        log.debug(" is new the name {}", (Object)actionName);
                    }
                    if (predictions.containsKey(actionName)) {
                        log.warn("cannot put action as its already there {}", (Object)actionName);
                        continue;
                    }
                    predictions.put(actionName, httpAction);
                    actionNameList.append(",");
                    actionNameList.append(actionName);
                    listOfActions.addAction(httpAction);
                }
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }

    private String getModifiedActionName(HttpPredictedAction httpAction) {
        StringBuilder actionNameBuilder = new StringBuilder(httpAction.getActionName());
        List<InputParameter> params = httpAction.getInputObjects();
        actionNameBuilder.append("_With");
        for (InputParameter param : params) {
            actionNameBuilder.append("_").append(param.getName());
        }
        return actionNameBuilder.toString();
    }

    private static Schema<?> resolveSchema(OpenAPI openAPI, String ref) {
        String refKey = ref.substring(ref.lastIndexOf("/") + 1);
        return (Schema)openAPI.getComponents().getSchemas().get(refKey);
    }

    private static MediaType findJsonMediaType(RequestBody requestBody) {
        for (String key : requestBody.getContent().keySet()) {
            if (!key.startsWith("application/json")) continue;
            return (MediaType)requestBody.getContent().get((Object)key);
        }
        return null;
    }
}

