/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.processor.selenium;

import com.t4a.JsonUtils;
import com.t4a.processor.AIProcessingException;
import com.t4a.processor.AIProcessor;
import com.t4a.processor.selenium.DriverActions;
import com.t4a.processor.selenium.URLSafety;
import com.t4a.processor.selenium.WebDriverAction;
import com.t4a.transform.PromptTransformer;
import java.io.File;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SeleniumProcessor {
    public static final Logger LOGGER = LoggerFactory.getLogger(SeleniumProcessor.class);

    default public void processWebAction(String prompt) throws AIProcessingException {
        DriverActions actions = (DriverActions)this.getTransformer().transformIntoPojo(prompt, DriverActions.class);
        String act = actions.getTypeOfActionToTakeOnWebDriver();
        LOGGER.debug("Processing the web action: {}", (Object)act);
        WebDriverAction action = WebDriverAction.valueOf(act.toUpperCase());
        if (WebDriverAction.GET.equals((Object)action) || WebDriverAction.NAVIGATE.equals((Object)action)) {
            String urlOfTheWebPage = this.getStringFromPrompt(prompt, "urlToClick");
            if (urlOfTheWebPage == null || urlOfTheWebPage.isEmpty()) {
                throw new AIProcessingException("URL to open cannot be null or empty");
            }
            URLSafety safe = (URLSafety)this.getTransformer().transformIntoPojo("is this url safe " + urlOfTheWebPage, URLSafety.class);
            if (!safe.isThisURLSafe()) {
                throw new AIProcessingException("The URL is not safe to open: " + urlOfTheWebPage);
            }
            LOGGER.debug("Opening the web page: {}", (Object)urlOfTheWebPage);
            this.getDriver().get(urlOfTheWebPage);
        } else if (WebDriverAction.CLICK.equals((Object)action)) {
            String textOfElementToClick = this.getStringFromPrompt(prompt, "textOfElementToClick");
            LOGGER.debug("Clicking on the element with text: {}", (Object)textOfElementToClick);
            WebElement elementToClick = this.getDriver().findElement(By.linkText((String)textOfElementToClick));
            elementToClick.click();
        } else if (WebDriverAction.TAKESCREENSHOT.equals((Object)action)) {
            String fileNameToSaveScreenshot = this.getStringFromPrompt(prompt, "fileNameToSaveScreenshot");
            LOGGER.debug("Clicking on the element with text: {}", (Object)fileNameToSaveScreenshot);
            TakesScreenshot ts = (TakesScreenshot)this.getDriver();
            File screenshotFile = (File)ts.getScreenshotAs(OutputType.FILE);
            try {
                boolean result = screenshotFile.renameTo(new File(fileNameToSaveScreenshot));
                LOGGER.debug("Screenshot saved successfully at: {} is {}", (Object)fileNameToSaveScreenshot, (Object)result);
            }
            catch (Exception e) {
                throw new AIProcessingException("Failed to save the screenshot file: " + e.getMessage());
            }
        }
    }

    default public String getStringFromPrompt(String prompt, String key) throws AIProcessingException {
        String urlOfTheWebPage = this.getTransformer().transformIntoJson(this.getUtils().createJson(key).toString(), prompt);
        urlOfTheWebPage = this.getUtils().getFieldValue(urlOfTheWebPage, key);
        return urlOfTheWebPage;
    }

    public boolean trueFalseQuery(String var1) throws AIProcessingException;

    public WebDriver getDriver();

    public JsonUtils getUtils();

    public PromptTransformer getTransformer();

    public AIProcessor getActionProcessor();
}

