/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.transform;

import com.google.gson.Gson;
import com.t4a.predict.PredictionLoader;
import com.t4a.processor.AIProcessingException;
import com.t4a.transform.PromptTransformer;
import dev.langchain4j.model.chat.ChatLanguageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnthropicTransformer
implements PromptTransformer {
    private static final Logger log = LoggerFactory.getLogger(AnthropicTransformer.class);
    private Gson gson;
    private ChatLanguageModel anthropicChatModel;

    public AnthropicTransformer(Gson gson) {
        this.gson = gson;
        this.anthropicChatModel = PredictionLoader.getInstance().getAnthropicChatModel();
    }

    public AnthropicTransformer() {
        this.gson = new Gson();
        this.anthropicChatModel = PredictionLoader.getInstance().getAnthropicChatModel();
    }

    @Override
    public String getJSONResponseFromAI(String prompt, String jsonStr) {
        jsonStr = PredictionLoader.getInstance().getAnthropicChatModel().generate(" Here is your prompt {" + prompt + "} - here is the json - " + jsonStr + " - populate the fieldValue and return the json");
        return jsonStr;
    }

    @Override
    public String transformIntoJson(String json, String prompt, String funName, String description) throws AIProcessingException {
        return this.anthropicChatModel.generate(" here is you prompt { " + prompt + "} and here is your json " + json + " - fill the json with values and return");
    }
}

