/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.transform;

import com.google.gson.Gson;
import com.t4a.predict.PredictionLoader;
import com.t4a.processor.AIProcessingException;
import com.t4a.transform.PromptTransformer;
import dev.langchain4j.model.chat.ChatLanguageModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAIPromptTransformer
implements PromptTransformer {
    private static final Logger log = LoggerFactory.getLogger(OpenAIPromptTransformer.class);
    private Gson gson;
    private ChatLanguageModel openAiChatModel;

    public OpenAIPromptTransformer(Gson gson) {
        this.gson = gson;
        this.openAiChatModel = PredictionLoader.getInstance().getOpenAiChatModel();
    }

    public OpenAIPromptTransformer() {
        this.gson = new Gson();
        this.openAiChatModel = PredictionLoader.getInstance().getOpenAiChatModel();
    }

    @Override
    public String getJSONResponseFromAI(String prompt, String jsonStr) {
        jsonStr = PredictionLoader.getInstance().getOpenAiChatModel().generate(" Here is your prompt {" + prompt + "} - here is the json - " + jsonStr + " - populate the fieldValue and return the json");
        return jsonStr;
    }

    @Override
    public String transformIntoJson(String json, String prompt, String funName, String description) throws AIProcessingException {
        return this.openAiChatModel.generate(" here is you prompt { " + prompt + "} and here is your json " + json + " - fill the json with values and return");
    }
}

