/*
 * Decompiled with CFR 0.152.
 */
package io.github.vshnv.adapt.adapter;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.OnLifecycleEvent;
import io.github.vshnv.adapt.adapter.AdapterLifecycleRegistry;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005*\u0001\u0012\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\bH\u0016R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00030\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lio/github/vshnv/adapt/adapter/AdapterLifecycleRegistry;", "Landroidx/lifecycle/LifecycleRegistry;", "owner", "Landroidx/lifecycle/LifecycleOwner;", "parentLifecycle", "Landroidx/lifecycle/Lifecycle;", "(Landroidx/lifecycle/LifecycleOwner;Landroidx/lifecycle/Lifecycle;)V", "value", "Landroidx/lifecycle/Lifecycle$State;", "highestState", "getHighestState", "()Landroidx/lifecycle/Lifecycle$State;", "setHighestState", "(Landroidx/lifecycle/Lifecycle$State;)V", "ownerWeakRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "parentLifecycleObserver", "io/github/vshnv/adapt/adapter/AdapterLifecycleRegistry$parentLifecycleObserver$1", "Lio/github/vshnv/adapt/adapter/AdapterLifecycleRegistry$parentLifecycleObserver$1;", "destroy", "", "ignoreParent", "observeParent", "setCurrentState", "nextState", "adapt_release"})
public final class AdapterLifecycleRegistry
extends LifecycleRegistry {
    @NotNull
    private final Lifecycle parentLifecycle;
    @NotNull
    private final WeakReference<LifecycleOwner> ownerWeakRef;
    @NotNull
    private final parentLifecycleObserver.1 parentLifecycleObserver;
    @NotNull
    private Lifecycle.State highestState;

    public AdapterLifecycleRegistry(@NotNull LifecycleOwner owner, @NotNull Lifecycle parentLifecycle) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)parentLifecycle, (String)"parentLifecycle");
        super(owner);
        this.parentLifecycle = parentLifecycle;
        this.ownerWeakRef = new WeakReference<LifecycleOwner>(owner);
        this.parentLifecycleObserver = new LifecycleObserver(this){
            final /* synthetic */ AdapterLifecycleRegistry this$0;
            {
                this.this$0 = $receiver;
            }

            @OnLifecycleEvent(value=Lifecycle.Event.ON_ANY)
            public final void onAny() {
                if (AdapterLifecycleRegistry.access$getOwnerWeakRef$p(this.this$0).get() == null) {
                    AdapterLifecycleRegistry.access$ignoreParent(this.this$0);
                    return;
                }
                Lifecycle.State state = AdapterLifecycleRegistry.access$getParentLifecycle$p(this.this$0).getCurrentState();
                Intrinsics.checkNotNullExpressionValue((Object)state, (String)"parentLifecycle.currentState");
                this.this$0.setCurrentState(state);
            }
        };
        this.highestState = Lifecycle.State.INITIALIZED;
        Lifecycle.State state = this.parentLifecycle.getCurrentState();
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"parentLifecycle.currentState");
        Lifecycle.State currentParentState = state;
        if (currentParentState.compareTo((Enum)Lifecycle.State.INITIALIZED) > 0) {
            Lifecycle.State state2 = this.parentLifecycle.getCurrentState();
            Intrinsics.checkNotNullExpressionValue((Object)state2, (String)"parentLifecycle.currentState");
            this.setHighestState(state2);
            Lifecycle.State state3 = this.parentLifecycle.getCurrentState();
            Intrinsics.checkNotNullExpressionValue((Object)state3, (String)"parentLifecycle.currentState");
            this.setCurrentState(state3);
        }
        this.observeParent();
    }

    @NotNull
    public final Lifecycle.State getHighestState() {
        return this.highestState;
    }

    public final void setHighestState(@NotNull Lifecycle.State value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.highestState = value;
        if (this.getCurrentState().compareTo((Enum)Lifecycle.State.INITIALIZED) > 0) {
            if (this.parentLifecycle.getCurrentState().compareTo((Enum)value) <= 0) {
                Lifecycle.State state = this.parentLifecycle.getCurrentState();
                Intrinsics.checkNotNullExpressionValue((Object)state, (String)"parentLifecycle.currentState");
                this.setCurrentState(state);
            } else if (this.getCurrentState().compareTo((Enum)value) >= 0) {
                this.setCurrentState(value);
            }
        }
    }

    private final void observeParent() {
        this.parentLifecycle.addObserver((LifecycleObserver)this.parentLifecycleObserver);
    }

    private final void ignoreParent() {
        this.parentLifecycle.removeObserver((LifecycleObserver)this.parentLifecycleObserver);
    }

    public void setCurrentState(@NotNull Lifecycle.State nextState) {
        Lifecycle.State maxNextState;
        Intrinsics.checkNotNullParameter((Object)nextState, (String)"nextState");
        Lifecycle.State state = maxNextState = nextState.compareTo((Enum)this.highestState) > 0 ? this.highestState : nextState;
        if (nextState == Lifecycle.State.DESTROYED) {
            this.ignoreParent();
        }
        super.setCurrentState(maxNextState);
    }

    public final void destroy() {
        this.ignoreParent();
        this.setHighestState(Lifecycle.State.DESTROYED);
    }

    public static final /* synthetic */ WeakReference access$getOwnerWeakRef$p(AdapterLifecycleRegistry $this) {
        return $this.ownerWeakRef;
    }

    public static final /* synthetic */ void access$ignoreParent(AdapterLifecycleRegistry $this) {
        $this.ignoreParent();
    }

    public static final /* synthetic */ Lifecycle access$getParentLifecycle$p(AdapterLifecycleRegistry $this) {
        return $this.parentLifecycle;
    }
}

