/*
 * Decompiled with CFR 0.152.
 */
package io.github.vshnv.adapt.adapter;

import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.AsyncListDiffer;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.github.vshnv.adapt.adapter.AdaptAdapter;
import io.github.vshnv.adapt.adapter.AdaptViewHolder;
import io.github.vshnv.adapt.adapter.AdapterLifecycleRegistry;
import io.github.vshnv.adapt.dsl.ViewSource;
import io.github.vshnv.adapt.dsl.collector.CollectingBindable;
import io.github.vshnv.adapt.dsl.collector.CollectingLifecycleRenewAttachable;
import io.github.vshnv.adapt.extensions.ViewKt;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00014B\u0087\u0001\u0012\u001a\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0018\u00010\b\u0012\u001c\u0010\t\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\b0\n\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u0005\u0012\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0006H\u0016J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u001e\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0006H\u0016J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0016J\u0016\u0010,\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0016J\u0016\u0010-\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0016J$\u0010.\u001a\u00020\"2\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\f\u00100\u001a\b\u0012\u0004\u0012\u00020\"01H\u0016J\u001f\u00102\u001a\u00020\"2\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u0003\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\u0015\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u0018*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00170\u0017 \u0018*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \u0018*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00170\u0017\u0018\u00010\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u000e\u0012\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00065"}, d2={"Lio/github/vshnv/adapt/adapter/LifecycleAwareAdaptAdapter;", "T", "", "Lio/github/vshnv/adapt/adapter/AdaptAdapter;", "viewTypeMapper", "Lkotlin/Function2;", "", "defaultBinder", "Lio/github/vshnv/adapt/dsl/collector/CollectingBindable;", "viewBinders", "", "itemEquals", "", "itemContentEquals", "(Lkotlin/jvm/functions/Function2;Lio/github/vshnv/adapt/dsl/collector/CollectingBindable;Ljava/util/Map;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "currentList", "", "getCurrentList", "()Ljava/util/List;", "diffCallback", "Landroidx/recyclerview/widget/DiffUtil$ItemCallback;", "knownAffectedViewHolders", "", "Lio/github/vshnv/adapt/adapter/LifecycleAwareAdaptAdapter$LifecycleAwareAdaptViewHolder;", "kotlin.jvm.PlatformType", "", "mDiffer", "Landroidx/recyclerview/widget/AsyncListDiffer;", "getItem", "position", "(I)Ljava/lang/Object;", "getItemCount", "getItemViewType", "onBindViewHolder", "", "holder", "Lio/github/vshnv/adapt/adapter/AdaptViewHolder;", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onDetachedFromRecyclerView", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "onViewAttachedToWindow", "onViewDetachedFromWindow", "submitData", "data", "callback", "Lkotlin/Function0;", "submitDataSuspending", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "LifecycleAwareAdaptViewHolder", "adapt_release"})
@SourceDebugExtension(value={"SMAP\nLifecycleAwareAdaptAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LifecycleAwareAdaptAdapter.kt\nio/github/vshnv/adapt/adapter/LifecycleAwareAdaptAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1855#2,2:148\n*S KotlinDebug\n*F\n+ 1 LifecycleAwareAdaptAdapter.kt\nio/github/vshnv/adapt/adapter/LifecycleAwareAdaptAdapter\n*L\n76#1:148,2\n*E\n"})
public final class LifecycleAwareAdaptAdapter<T>
extends AdaptAdapter<T> {
    @Nullable
    private final Function2<T, Integer, Integer> viewTypeMapper;
    @Nullable
    private final CollectingBindable<T, ?> defaultBinder;
    @NotNull
    private final Map<Integer, CollectingBindable<T, ?>> viewBinders;
    @NotNull
    private final Function2<T, T, Boolean> itemEquals;
    @NotNull
    private final Function2<T, T, Boolean> itemContentEquals;
    private final Set<LifecycleAwareAdaptViewHolder<T>> knownAffectedViewHolders;
    @NotNull
    private final DiffUtil.ItemCallback<T> diffCallback;
    @NotNull
    private final AsyncListDiffer<T> mDiffer;

    public LifecycleAwareAdaptAdapter(@Nullable Function2<? super T, ? super Integer, Integer> viewTypeMapper, @Nullable CollectingBindable<T, ?> defaultBinder, @NotNull Map<Integer, CollectingBindable<T, ?>> viewBinders, @NotNull Function2<? super T, ? super T, Boolean> itemEquals2, @NotNull Function2<? super T, ? super T, Boolean> itemContentEquals2) {
        Intrinsics.checkNotNullParameter(viewBinders, (String)"viewBinders");
        Intrinsics.checkNotNullParameter(itemEquals2, (String)"itemEquals");
        Intrinsics.checkNotNullParameter(itemContentEquals2, (String)"itemContentEquals");
        this.viewTypeMapper = viewTypeMapper;
        this.defaultBinder = defaultBinder;
        this.viewBinders = viewBinders;
        this.itemEquals = itemEquals2;
        this.itemContentEquals = itemContentEquals2;
        this.knownAffectedViewHolders = Collections.newSetFromMap(new WeakHashMap());
        this.diffCallback = new DiffUtil.ItemCallback<T>(this){
            final /* synthetic */ LifecycleAwareAdaptAdapter<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean areItemsTheSame(@NotNull T oldItem, @NotNull T newItem) {
                Intrinsics.checkNotNullParameter(oldItem, (String)"oldItem");
                Intrinsics.checkNotNullParameter(newItem, (String)"newItem");
                return (Boolean)LifecycleAwareAdaptAdapter.access$getItemEquals$p(this.this$0).invoke(oldItem, newItem);
            }

            public boolean areContentsTheSame(@NotNull T oldItem, @NotNull T newItem) {
                Intrinsics.checkNotNullParameter(oldItem, (String)"oldItem");
                Intrinsics.checkNotNullParameter(newItem, (String)"newItem");
                return (Boolean)LifecycleAwareAdaptAdapter.access$getItemContentEquals$p(this.this$0).invoke(oldItem, newItem);
            }
        };
        this.mDiffer = new AsyncListDiffer((RecyclerView.Adapter)this, this.diffCallback);
    }

    @Override
    @NotNull
    public List<T> getCurrentList() {
        List list = this.mDiffer.getCurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"mDiffer.currentList");
        return list;
    }

    public int getItemViewType(int position) {
        int n;
        Function2<T, Integer, Integer> function2 = this.viewTypeMapper;
        if (function2 != null) {
            Function2<T, Integer, Integer> it = function2;
            boolean bl = false;
            n = ((Number)it.invoke(this.getItem(position), (Object)position)).intValue();
        } else {
            n = super.getItemViewType(position);
        }
        return n;
    }

    @NotNull
    public AdaptViewHolder<T> onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        CollectingBindable<T, ?> collectingBindable = this.viewBinders.get(viewType);
        if (collectingBindable == null && (collectingBindable = this.defaultBinder) == null) {
            throw new AssertionError((Object)"Adapt found ViewType with no bound view creator or any default view creator, Cannot proceed!");
        }
        CollectingBindable<T, ?> binderItem = collectingBindable;
        ViewSource viewSource = (ViewSource)binderItem.getCreator().invoke((Object)parent);
        return new LifecycleAwareAdaptViewHolder(viewSource.getView(), (Function2<? super RecyclerView.ViewHolder, ? super LifecycleOwner, Unit>)((Function2)new Function2<RecyclerView.ViewHolder, LifecycleOwner, Unit>(binderItem, this, (ViewSource<? extends Object>)viewSource){
            final /* synthetic */ CollectingBindable<T, ?> $binderItem;
            final /* synthetic */ LifecycleAwareAdaptAdapter<T> this$0;
            final /* synthetic */ ViewSource<? extends Object> $viewSource;
            {
                this.$binderItem = $binderItem;
                this.this$0 = $receiver;
                this.$viewSource = $viewSource;
                super(2);
            }

            public final void invoke(@NotNull RecyclerView.ViewHolder viewHolder, @NotNull LifecycleOwner lifecycleOwner) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
                    Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
                    CollectingLifecycleRenewAttachable<T, ?> collectingLifecycleRenewAttachable = this.$binderItem.getLifecycleRenewAttachable();
                    if (collectingLifecycleRenewAttachable == null || (collectingLifecycleRenewAttachable = collectingLifecycleRenewAttachable.getAttach()) == null) break block0;
                    collectingLifecycleRenewAttachable.invoke(viewHolder, this.this$0.getCurrentList().get(viewHolder.getAdapterPosition()), this.$viewSource, lifecycleOwner);
                }
            }
        }), (Function3)new Function3<LifecycleAwareAdaptViewHolder<T>, Integer, T, Unit>(binderItem, viewSource){
            final /* synthetic */ CollectingBindable<T, ?> $binderItem;
            final /* synthetic */ ViewSource<? extends Object> $viewSource;
            {
                this.$binderItem = $binderItem;
                this.$viewSource = $viewSource;
                super(3);
            }

            public final void invoke(@NotNull LifecycleAwareAdaptViewHolder<T> viewHolder, int n, @NotNull T data) {
                Intrinsics.checkNotNullParameter(viewHolder, (String)"viewHolder");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Function3<RecyclerView.ViewHolder, T, ViewSource<?>, Unit> function3 = this.$binderItem.getBindDataToView();
                if (function3 == null) {
                    return;
                }
                Function3<RecyclerView.ViewHolder, T, ViewSource<?>, Unit> bindDataToView = function3;
                bindDataToView.invoke(viewHolder, data, this.$viewSource);
            }
        });
    }

    public int getItemCount() {
        return this.mDiffer.getCurrentList().size();
    }

    public void onBindViewHolder(@NotNull AdaptViewHolder<T> holder, int position) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        T data = this.getItem(position);
        holder.bind(position, data);
    }

    private final T getItem(int position) {
        Object e = this.mDiffer.getCurrentList().get(position);
        Intrinsics.checkNotNullExpressionValue(e, (String)"mDiffer.currentList[position]");
        return (T)e;
    }

    @Override
    @Nullable
    public Object submitDataSuspending(@NotNull List<? extends T> data, @NotNull Continuation<? super Unit> $completion) {
        Continuation<? super Unit> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        this.mDiffer.submitList(data, new Runnable((Continuation<? super Unit>)continuation2){
            final /* synthetic */ Continuation<Unit> $continuation;
            {
                this.$continuation = $continuation;
            }

            public final void run() {
                this.$continuation.resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }
        });
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void submitData(@NotNull List<? extends T> data, @NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.mDiffer.submitList(data, () -> LifecycleAwareAdaptAdapter.submitData$lambda$2(callback));
    }

    public void onDetachedFromRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        super.onDetachedFromRecyclerView(recyclerView);
        Set<LifecycleAwareAdaptViewHolder<T>> set = this.knownAffectedViewHolders;
        Intrinsics.checkNotNullExpressionValue(set, (String)"knownAffectedViewHolders");
        Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)set);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LifecycleAwareAdaptViewHolder viewHolder = (LifecycleAwareAdaptViewHolder)((Object)element$iv);
            boolean bl = false;
            viewHolder.notifyDetached(recyclerView);
        }
    }

    public void onViewAttachedToWindow(@NotNull AdaptViewHolder<T> holder) {
        AdapterLifecycleRegistry registry;
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        LifecycleAwareAdaptViewHolder holder2 = (LifecycleAwareAdaptViewHolder)holder;
        View view = holder2.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"holder.itemView");
        LifecycleOwner lifecycleOwner = ViewKt.findViewTreeLifecycleOwner(view);
        if (lifecycleOwner == null) {
            return;
        }
        LifecycleOwner lifecycleOwner2 = lifecycleOwner;
        holder2.handleLifecycleSetup(lifecycleOwner2);
        AdapterLifecycleRegistry adapterLifecycleRegistry = registry = holder2.getLifecycleRegistry();
        if (adapterLifecycleRegistry != null) {
            adapterLifecycleRegistry.setHighestState(Lifecycle.State.RESUMED);
        }
        this.knownAffectedViewHolders.add(holder2);
    }

    public void onViewDetachedFromWindow(@NotNull AdaptViewHolder<T> holder) {
        AdapterLifecycleRegistry registry;
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        AdapterLifecycleRegistry adapterLifecycleRegistry = registry = ((LifecycleAwareAdaptViewHolder)holder).getLifecycleRegistry();
        if (adapterLifecycleRegistry != null) {
            adapterLifecycleRegistry.setHighestState(Lifecycle.State.CREATED);
        }
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
    }

    private static final void submitData$lambda$2(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ Function2 access$getItemEquals$p(LifecycleAwareAdaptAdapter $this) {
        return $this.itemEquals;
    }

    public static final /* synthetic */ Function2 access$getItemContentEquals$p(LifecycleAwareAdaptAdapter $this) {
        return $this.itemContentEquals;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003BM\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0007\u0012$\u0010\n\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0000\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u000fJ\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010\u000f*\u00020\u0005H\u0002R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0000\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00018\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lio/github/vshnv/adapt/adapter/LifecycleAwareAdaptAdapter$LifecycleAwareAdaptViewHolder;", "T", "Lio/github/vshnv/adapt/adapter/AdaptViewHolder;", "Landroidx/lifecycle/LifecycleOwner;", "view", "Landroid/view/View;", "attachLifecycle", "Lkotlin/Function2;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "", "bindRaw", "Lkotlin/Function3;", "", "(Landroid/view/View;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function3;)V", "lastAttachedRecyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "lastData", "Ljava/lang/Object;", "lastLifecycleOwner", "<set-?>", "Lio/github/vshnv/adapt/adapter/AdapterLifecycleRegistry;", "lifecycleRegistry", "getLifecycleRegistry", "()Lio/github/vshnv/adapt/adapter/AdapterLifecycleRegistry;", "bind", "idx", "data", "(ILjava/lang/Object;)V", "getLifecycle", "Landroidx/lifecycle/Lifecycle;", "handleLifecycleSetup", "lifecycleOwner", "notifyDetached", "recyclerView", "renewLifecycleRegistry", "findClosestRecyclerView", "adapt_release"})
    @SourceDebugExtension(value={"SMAP\nLifecycleAwareAdaptAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LifecycleAwareAdaptAdapter.kt\nio/github/vshnv/adapt/adapter/LifecycleAwareAdaptAdapter$LifecycleAwareAdaptViewHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
    public static final class LifecycleAwareAdaptViewHolder<T>
    extends AdaptViewHolder<T>
    implements LifecycleOwner {
        @NotNull
        private final Function2<RecyclerView.ViewHolder, LifecycleOwner, Unit> attachLifecycle;
        @NotNull
        private final Function3<LifecycleAwareAdaptViewHolder<T>, Integer, T, Unit> bindRaw;
        @Nullable
        private T lastData;
        @Nullable
        private RecyclerView lastAttachedRecyclerView;
        @Nullable
        private LifecycleOwner lastLifecycleOwner;
        @Nullable
        private AdapterLifecycleRegistry lifecycleRegistry;

        public LifecycleAwareAdaptViewHolder(@NotNull View view, @NotNull Function2<? super RecyclerView.ViewHolder, ? super LifecycleOwner, Unit> attachLifecycle, @NotNull Function3<? super LifecycleAwareAdaptViewHolder<T>, ? super Integer, ? super T, Unit> bindRaw) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter(attachLifecycle, (String)"attachLifecycle");
            Intrinsics.checkNotNullParameter(bindRaw, (String)"bindRaw");
            super(view);
            this.attachLifecycle = attachLifecycle;
            this.bindRaw = bindRaw;
        }

        @Nullable
        public final AdapterLifecycleRegistry getLifecycleRegistry() {
            return this.lifecycleRegistry;
        }

        @NotNull
        public Lifecycle getLifecycle() {
            AdapterLifecycleRegistry adapterLifecycleRegistry = this.lifecycleRegistry;
            if (adapterLifecycleRegistry == null) {
                boolean bl = false;
                String string = "LifeCycle of " + (Object)((Object)this) + " accessed before attempting bind";
                throw new IllegalArgumentException(string.toString());
            }
            return (Lifecycle)adapterLifecycleRegistry;
        }

        @Override
        public void bind(int idx, T data) {
            if (!Intrinsics.areEqual(this.lastData, data) && this.lastLifecycleOwner != null) {
                LifecycleOwner lifecycleOwner = this.lastLifecycleOwner;
                Intrinsics.checkNotNull((Object)lifecycleOwner);
                this.renewLifecycleRegistry(lifecycleOwner);
            }
            this.bindRaw.invoke((Object)this, (Object)idx, data);
            this.lastData = data;
        }

        public final void handleLifecycleSetup(@NotNull LifecycleOwner lifecycleOwner) {
            Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
            if (Intrinsics.areEqual((Object)this.lastLifecycleOwner, (Object)lifecycleOwner)) {
                return;
            }
            this.lastLifecycleOwner = lifecycleOwner;
            View view = this.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
            this.lastAttachedRecyclerView = this.findClosestRecyclerView(view);
            this.renewLifecycleRegistry(lifecycleOwner);
        }

        public final void notifyDetached(@NotNull RecyclerView recyclerView) {
            Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
            if (!Intrinsics.areEqual((Object)this.lastAttachedRecyclerView, (Object)recyclerView)) {
                return;
            }
            AdapterLifecycleRegistry adapterLifecycleRegistry = this.lifecycleRegistry;
            if (adapterLifecycleRegistry != null) {
                adapterLifecycleRegistry.destroy();
            }
            this.lifecycleRegistry = null;
            this.lastLifecycleOwner = null;
            this.lastAttachedRecyclerView = null;
        }

        private final void renewLifecycleRegistry(LifecycleOwner lifecycleOwner) {
            AdapterLifecycleRegistry adapterLifecycleRegistry = this.lifecycleRegistry;
            if (adapterLifecycleRegistry != null) {
                adapterLifecycleRegistry.destroy();
            }
            LifecycleOwner lifecycleOwner2 = this;
            Lifecycle lifecycle = lifecycleOwner.getLifecycle();
            Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"lifecycleOwner.lifecycle");
            this.lifecycleRegistry = new AdapterLifecycleRegistry(lifecycleOwner2, lifecycle);
            this.attachLifecycle.invoke((Object)this, (Object)this);
        }

        private final RecyclerView findClosestRecyclerView(View $this$findClosestRecyclerView) {
            ViewParent parent;
            return $this$findClosestRecyclerView instanceof RecyclerView ? (RecyclerView)$this$findClosestRecyclerView : ((parent = $this$findClosestRecyclerView.getParent()) instanceof View ? this.findClosestRecyclerView((View)parent) : null);
        }
    }
}

