/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.windows;

import com.sun.jna.WString;
import purejavahidapi.shared.SyncPoint;
import purejavahidapi.windows.Kernel32Library;
import purejavahidapi.windows.SetupApiLibrary;
import purejavahidapi.windows.User32Library;
import purejavahidapi.windows.WinDef;
import purejavahidapi.windows.WindowsBackend;
import purejavahidapi.windows.WtsApi32Library;

public class DeviceRemovalHandler
implements WinDef.WindowProc {
    private WindowsBackend m_WindowsBackend;
    private SyncPoint m_StartupSync;

    public DeviceRemovalHandler(WindowsBackend windowsBackend) {
        this.m_WindowsBackend = windowsBackend;
        this.m_StartupSync = new SyncPoint(2);
        Runnable threadRunnable = new Runnable(){

            @Override
            public void run() {
                WinDef.HWND hWnd;
                WString wndClassName = new WString("WindowClass");
                WinDef.HMODULE hInst = Kernel32Library.GetModuleHandle(null);
                if (hInst == null) {
                    WindowsBackend.reportLastError();
                }
                User32Library.WNDCLASSEX wndClassEx = new User32Library.WNDCLASSEX();
                wndClassEx.hInstance = hInst;
                wndClassEx.lpfnWndProc = DeviceRemovalHandler.this;
                wndClassEx.lpszClassName = wndClassName;
                WinDef.ATOM wndClassRef = User32Library.RegisterClassEx(wndClassEx);
                if (wndClassRef == null) {
                    WindowsBackend.reportLastError();
                }
                if ((hWnd = User32Library.CreateWindowEx(8, "WindowClass", "", 0, 0, 0, 0, 0, null, null, hInst, null)) == null) {
                    WindowsBackend.reportLastError();
                }
                if (!WtsApi32Library.WTSRegisterSessionNotification(hWnd, 0)) {
                    WindowsBackend.reportLastError();
                }
                WinDef.DEV_BROADCAST_DEVICEINTERFACE notificationFilter = new WinDef.DEV_BROADCAST_DEVICEINTERFACE();
                notificationFilter.dbcc_size = notificationFilter.size();
                notificationFilter.dbcc_devicetype = 5;
                notificationFilter.dbcc_classguid = WinDef.GUID_DEVINTERFACE_USB_DEVICE;
                User32Library.HDEVNOTIFY hDevNotify = User32Library.RegisterDeviceNotification(hWnd, notificationFilter, 0);
                if (hDevNotify == null) {
                    WindowsBackend.reportLastError();
                }
                DeviceRemovalHandler.this.m_StartupSync.waitAndSync();
                User32Library.MSG msg = new User32Library.MSG();
                while (User32Library.GetMessage(msg, hWnd, 0, 0) != 0) {
                    User32Library.TranslateMessage(msg);
                    User32Library.DispatchMessage(msg);
                }
                if (!User32Library.UnregisterDeviceNotification(hDevNotify)) {
                    WindowsBackend.reportLastError();
                }
                if (!WtsApi32Library.WTSUnRegisterSessionNotification(hWnd)) {
                    WindowsBackend.reportLastError();
                }
                if (!User32Library.UnregisterClass(wndClassRef, (WinDef.HINSTANCE)hInst)) {
                    WindowsBackend.reportLastError();
                }
                if (!User32Library.DestroyWindow(hWnd)) {
                    WindowsBackend.reportLastError();
                }
            }
        };
        Thread thread = new Thread(threadRunnable, this.getClass().getSimpleName());
        thread.setDaemon(true);
        thread.start();
        this.m_StartupSync.waitAndSync();
    }

    @Override
    public WinDef.LRESULT callback(WinDef.HWND hwnd, int uMsg, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        switch (uMsg) {
            case 2: {
                User32Library.PostQuitMessage(0);
                return new WinDef.LRESULT(0L);
            }
            case 537: {
                WinDef.LRESULT lResult = this.onDeviceChange(wParam, lParam);
                return lResult != null ? lResult : User32Library.DefWindowProc(hwnd, uMsg, wParam, lParam);
            }
        }
        return User32Library.DefWindowProc(hwnd, uMsg, wParam, lParam);
    }

    protected WinDef.LRESULT onDeviceChange(WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        switch (wParam.intValue()) {
            case 32772: {
                return this.onDeviceChangeRemoveComplete(lParam);
            }
        }
        return null;
    }

    private void handleDeviceRemoval(String name) {
        SetupApiLibrary.HDEVINFO deviceInfoHandle = SetupApiLibrary.SetupDiCreateDeviceInfoList(null, null);
        if (deviceInfoHandle != WinDef.INVALID_HANDLE_VALUE) {
            SetupApiLibrary.SP_DEVICE_INTERFACE_DATA deviceInterfaceData = new SetupApiLibrary.SP_DEVICE_INTERFACE_DATA();
            deviceInterfaceData.cbSize = deviceInterfaceData.size();
            if (SetupApiLibrary.SetupDiOpenDeviceInterface(deviceInfoHandle, name, 0, deviceInterfaceData)) {
                int[] deviceIdLen;
                char[] deviceIdChars;
                SetupApiLibrary.SP_DEVINFO_DATA deviceInfoData = new SetupApiLibrary.SP_DEVINFO_DATA();
                deviceInfoData.cbSize = deviceInfoData.size();
                if (SetupApiLibrary.SetupDiEnumDeviceInfo(deviceInfoHandle, 0, deviceInfoData) && SetupApiLibrary.SetupDiGetDeviceInstanceId(deviceInfoHandle, deviceInfoData, deviceIdChars = new char[255], deviceIdChars.length, deviceIdLen = new int[1])) {
                    String deviceId = new String(deviceIdChars, 0, deviceIdLen[0] - 1);
                    this.m_WindowsBackend.deviceRemoved(deviceId);
                }
                if (!SetupApiLibrary.SetupDiDeleteDeviceInterfaceData(deviceInfoHandle, deviceInterfaceData)) {
                    WindowsBackend.reportLastError();
                }
            }
        }
        if (!SetupApiLibrary.SetupDiDestroyDeviceInfoList(deviceInfoHandle)) {
            WindowsBackend.reportLastError();
        }
    }

    protected WinDef.LRESULT onDeviceChangeArrivalOrRemoveComplete(WinDef.LPARAM lParam, String action) {
        WinDef.DEV_BROADCAST_HDR bhdr = new WinDef.DEV_BROADCAST_HDR(lParam.longValue());
        switch (bhdr.dbch_devicetype) {
            case 5: {
                WinDef.DEV_BROADCAST_DEVICEINTERFACE bdif = new WinDef.DEV_BROADCAST_DEVICEINTERFACE(bhdr.getPointer());
                this.handleDeviceRemoval(bdif.get_dbcc_name());
                break;
            }
            default: {
                return null;
            }
        }
        return new WinDef.LRESULT(1L);
    }

    protected WinDef.LRESULT onDeviceChangeRemoveComplete(WinDef.LPARAM lParam) {
        return this.onDeviceChangeArrivalOrRemoveComplete(lParam, "Remove Complete");
    }
}

