/*
 * Decompiled with CFR 0.152.
 */
package io.github.wasabithumb.josdirs.path;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OSPath {
    @Contract(value="_ -> this")
    @NotNull
    public OSPath appName(@Nullable String var1);

    @Contract(value="_ -> this")
    @NotNull
    public OSPath appAuthor(@Nullable String var1);

    @Contract(value="_ -> this")
    @NotNull
    public OSPath appVersion(@Nullable String var1);

    @Contract(value="_ -> this")
    @NotNull
    public OSPath roaming(boolean var1);

    @Contract(value="-> new")
    @NotNull
    public String toString();

    @NotNull
    default public File toFile() {
        return new File(this.toString());
    }

    @NotNull
    default public URI toURI() {
        return this.toFile().toURI();
    }

    @NotNull
    default public URL toURL() {
        try {
            return this.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new AssertionError("File URL from stdlib is malformed", e);
        }
    }

    @NotNull
    default public Path toPath() {
        return FileSystems.getDefault().getPath(this.toString(), new String[0]);
    }
}

