/*
 * Decompiled with CFR 0.152.
 */
package io.github.wasabithumb.josdirs.platform.unix;

import io.github.wasabithumb.josdirs.AbstractOSDirs;
import io.github.wasabithumb.josdirs.loader.LibraryLoader;
import io.github.wasabithumb.josdirs.path.AbstractOSPath;
import io.github.wasabithumb.josdirs.path.BasicOSPath;
import io.github.wasabithumb.josdirs.path.OSPath;
import io.github.wasabithumb.josdirs.platform.unix.jni.JNI;
import io.github.wasabithumb.josdirs.platform.unix.xdg.XDGUserDirs;
import io.github.wasabithumb.josdirs.util.SystemArch;
import io.github.wasabithumb.josdirs.util.SystemUtil;
import java.io.File;
import java.nio.file.FileSystems;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class UnixOSDirs
extends AbstractOSDirs {
    protected final Supplier<String> home;
    protected final Map<String, String> env;
    protected final XDGUserDirs xdg;

    UnixOSDirs(@NotNull Logger logger) {
        super(logger);
        Supplier<String> home;
        SystemArch arch = SystemUtil.arch();
        if (arch != SystemArch.UNKNOWN) {
            String archName = arch.name().toLowerCase(Locale.ROOT);
            logger.log(Level.FINE, "[unix] Loading natives (" + archName + ")");
            LibraryLoader.create().loadAssert("linux", archName, "libjosdirs.so");
            JNI jni = new JNI();
            home = jni::homePath;
        } else {
            logger.log(Level.FINE, "[unix] Unknown CPU architecture, using fallback system");
            String[] path = new String[]{System.getProperty("user.home")};
            if (path[0] == null) {
                path[0] = FileSystems.getDefault().getPath("~", new String[0]).toAbsolutePath().toString();
            }
            home = () -> path[0];
        }
        this.home = home;
        this.env = System.getenv();
        this.xdg = new XDGUserDirs(new File(this.userConfig().toFile(), "user-dirs.dirs"), logger);
    }

    @NotNull
    protected String rel(@NotNull CharSequence path) {
        return AbstractOSPath.concat((char)'/', (CharSequence)this.home.get(), (CharSequence[])new CharSequence[]{path});
    }

    @NotNull
    protected OSPath xdg(@NotNull String key, @NotNull String defaultName) {
        String path = this.xdg.get(this.home.get(), key);
        if (path == null) {
            path = this.rel(defaultName);
        }
        return new BasicOSPath((CharSequence)path, '/', 0);
    }

    @NotNull
    public OSPath userData() {
        String path = this.env.get("XDG_DATA_HOME");
        if (path == null) {
            path = this.rel(".local/share");
        }
        return new BasicOSPath((CharSequence)path, '/', 6);
    }

    @NotNull
    public OSPath userConfig() {
        String path = this.env.get("XDG_CONFIG_HOME");
        if (path == null) {
            path = this.rel(".config");
        }
        return new BasicOSPath((CharSequence)path, '/', 6);
    }

    @NotNull
    public OSPath userCache() {
        String path = this.env.get("XDG_CACHE_HOME");
        if (path == null) {
            path = this.rel(".cache");
        }
        return new BasicOSPath((CharSequence)path, '/', 6);
    }

    @NotNull
    public OSPath userHome() {
        return new BasicOSPath((CharSequence)this.home.get(), '/', 0);
    }

    @NotNull
    public OSPath userDownloads() {
        return this.xdg("DOWNLOAD", "Downloads");
    }

    @NotNull
    public OSPath userDocuments() {
        return this.xdg("DOCUMENTS", "Documents");
    }

    @NotNull
    public OSPath userDesktop() {
        return this.xdg("DESKTOP", "Desktop");
    }

    @NotNull
    public OSPath userMusic() {
        return this.xdg("MUSIC", "Music");
    }

    @NotNull
    public OSPath userPictures() {
        return this.xdg("PICTURES", "Pictures");
    }

    @NotNull
    public OSPath userVideos() {
        return this.xdg("VIDEOS", "Videos");
    }
}

