/*
 * Decompiled with CFR 0.152.
 */
package io.github.wasabithumb.josdirs.platform.windows;

import io.github.wasabithumb.josdirs.AbstractOSDirs;
import io.github.wasabithumb.josdirs.loader.LibraryLoader;
import io.github.wasabithumb.josdirs.path.AbstractOSPath;
import io.github.wasabithumb.josdirs.path.BasicOSPath;
import io.github.wasabithumb.josdirs.path.OSPath;
import io.github.wasabithumb.josdirs.platform.windows.jni.JNI;
import io.github.wasabithumb.josdirs.platform.windows.path.WindowsUserDataOSPath;
import io.github.wasabithumb.josdirs.util.SystemArch;
import io.github.wasabithumb.josdirs.util.SystemUtil;
import java.util.Locale;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class WindowsOSDirs
extends AbstractOSDirs {
    protected final JNI j;
    protected final boolean hasJ;

    public WindowsOSDirs(@NotNull Logger logger) {
        super(logger);
        SystemArch arch = SystemUtil.arch();
        if (arch == SystemArch.X86_64 || arch == SystemArch.I686) {
            logger.log(Level.FINE, "[windows] Loading native library");
            LibraryLoader.create().loadAssert("windows", arch.name().toLowerCase(Locale.ROOT), "josdirs.dll");
            this.j = new JNI();
            this.hasJ = true;
        } else {
            logger.log(Level.FINE, "[windows] Unsupported architecture (" + arch.name() + "), using fallback");
            this.j = null;
            this.hasJ = false;
        }
    }

    @ApiStatus.Internal
    @NotNull
    public String home() {
        String home;
        if (this.hasJ && (home = this.j.homeDir()) != null) {
            return home;
        }
        home = System.getProperty("user.home");
        if (home != null) {
            return home;
        }
        return "C:/Users/Default";
    }

    @ApiStatus.Internal
    @NotNull
    public String localAppData() {
        String dir;
        if (this.hasJ && (dir = this.j.localAppDataDir()) != null) {
            return dir;
        }
        return AbstractOSPath.concat((char)'\\', (CharSequence)this.home(), (CharSequence[])new CharSequence[]{"AppData", "Local"});
    }

    @ApiStatus.Internal
    @NotNull
    public String roamingAppData() {
        String dir;
        if (this.hasJ && (dir = this.j.roamingAppDataDir()) != null) {
            return dir;
        }
        return AbstractOSPath.concat((char)'\\', (CharSequence)this.home(), (CharSequence[])new CharSequence[]{"AppData", "Roaming"});
    }

    @NotNull
    private OSPath nativeOrRelative(@NotNull Function<JNI, String> fn, @NotNull String fallback) {
        String dir;
        if (this.hasJ && (dir = fn.apply(this.j)) != null) {
            return new BasicOSPath((CharSequence)dir, '\\', 0);
        }
        return new BasicOSPath((CharSequence)AbstractOSPath.concat((char)'\\', (CharSequence)this.home(), (CharSequence[])new CharSequence[]{fallback}), '\\', 0);
    }

    @NotNull
    public OSPath userData() {
        return new WindowsUserDataOSPath(this);
    }

    @NotNull
    public OSPath userConfig() {
        return this.userData();
    }

    @NotNull
    public OSPath userCache() {
        return new WindowsUserDataOSPath(this, "Cache");
    }

    @NotNull
    public OSPath userHome() {
        return new BasicOSPath((CharSequence)this.home(), '\\', 0);
    }

    @NotNull
    public OSPath userDownloads() {
        return this.nativeOrRelative(JNI::downloadsDir, "Downloads");
    }

    @NotNull
    public OSPath userDocuments() {
        return this.nativeOrRelative(JNI::documentsDir, "Documents");
    }

    @NotNull
    public OSPath userDesktop() {
        return this.nativeOrRelative(JNI::desktopDir, "Desktop");
    }

    @NotNull
    public OSPath userMusic() {
        return this.nativeOrRelative(JNI::musicDir, "Music");
    }

    @NotNull
    public OSPath userPictures() {
        return this.nativeOrRelative(JNI::picturesDir, "Pictures");
    }

    @NotNull
    public OSPath userVideos() {
        return this.nativeOrRelative(JNI::videosDir, "Videos");
    }
}

