/*
 * Decompiled with CFR 0.152.
 */
package wechaty.user;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Date;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import wechaty.Wechaty;
import wechaty.helper.ImplicitHelper$;
import wechaty.puppet.Puppet;
import wechaty.puppet.ResourceBox;
import wechaty.puppet.schemas.Message;
import wechaty.puppet.schemas.MiniProgram;
import wechaty.puppet.schemas.Puppet$;
import wechaty.puppet.schemas.UrlLink;
import wechaty.user.Contact;
import wechaty.user.Conversation;
import wechaty.user.Image;
import wechaty.user.MiniProgram;
import wechaty.user.Room;
import wechaty.user.Room$;
import wechaty.user.UrlLink;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001\u0002\u0013&\u0001)B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u000f\u0002\u0011\t\u0011)A\u0006\u0011\")\u0011\u000b\u0001C\u0001%\"9\u0001\f\u0001b\u0001\n\u0013I\u0006BB1\u0001A\u0003%!\f\u0003\u0005c\u0001!\u0015\r\u0011\"\u0001d\u0011\u0015\u0011\b\u0001\"\u0003t\u0011\u0015!\b\u0001\"\u0011v\u0011\u00151\b\u0001\"\u0001x\u0011\u0015Y\b\u0001\"\u0001}\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aa!a\u0003\u0001\t\u00039\bBBA\u0007\u0001\u0011\u0005q\u000fC\u0004\u0002\u0010\u0001!\t!!\u0005\t\r\u0005}\u0001\u0001\"\u0001t\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!!\n\u0001\t\u0003\t9\u0003C\u0004\u0002&\u0001!\t!a\u000b\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u00022!9\u0011Q\u0005\u0001\u0005\u0002\u0005u\u0002bBA\u0013\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003+\u0002A\u0011AA,\u0011\u001d\ty\u0006\u0001C\u0001\u0003CBq!!\u001f\u0001\t\u0003\t9\u0006C\u0004\u0002|\u0001!\t!! \t\r\u0005\u0015\u0005\u0001\"\u0001v\u0011\u001d\t9\t\u0001C\u0001\u0003/Bq!!#\u0001\t\u0003\tY\tC\u0004\u0002\u0010\u0002!\t!!%\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\"9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0006bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003o\u0003A\u0011AA]\u0011\u001d\tY\f\u0001C\u0001\u0003{Cq!a0\u0001\t\u0003\t\tMA\u0004NKN\u001c\u0018mZ3\u000b\u0005\u0019:\u0013\u0001B;tKJT\u0011\u0001K\u0001\bo\u0016\u001c\u0007.\u0019;z\u0007\u0001\u00192\u0001A\u00162!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fMB\u0011!'O\u0007\u0002g)\u0011A'N\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003m]\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002q\u0005\u00191m\\7\n\u0005i\u001a$a\u0003'bufdunZ4j]\u001e\f\u0011\"\\3tg\u0006<W-\u00133\u0011\u0005u\"eB\u0001 C!\tyT&D\u0001A\u0015\t\t\u0015&\u0001\u0004=e>|GOP\u0005\u0003\u00076\na\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111)L\u0001\te\u0016\u001cx\u000e\u001c<feB\u0011\u0011J\u0014\b\u0003\u00152s!aP&\n\u0003!J!!T\u0014\u0002\u000f]+7\r[1us&\u0011q\n\u0015\u0002\u000f!V\u0004\b/\u001a;SKN|GN^3s\u0015\tiu%\u0001\u0004=S:LGO\u0010\u000b\u0003'^#\"\u0001\u0016,\u0011\u0005U\u0003Q\"A\u0013\t\u000b\u001d\u001b\u00019\u0001%\t\u000bm\u001a\u0001\u0019\u0001\u001f\u0002-5+e\nV%P\u001d~kU)\u0014\"F%~\u0003\u0016\t\u0016+F%:+\u0012A\u0017\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000bA\u0001\\1oO*\tq,\u0001\u0003kCZ\f\u0017BA#]\u0003]iUI\u0014+J\u001f:{V*R'C\u000bJ{\u0006+\u0011+U\u000bJs\u0005%A\u0004qCfdw.\u00193\u0016\u0003\u0011\u0004\"!Z8\u000f\u0005\u0019dgBA4k\u001b\u0005A'BA5(\u0003\u0019\u0001X\u000f\u001d9fi&\u00111\u000e[\u0001\bg\u000eDW-\\1t\u0013\tig.A\u0004NKN\u001c\u0018mZ3\u000b\u0005-D\u0017B\u00019r\u00059iUm]:bO\u0016\u0004\u0016-\u001f7pC\u0012T!!\u001c8\u0002\u000bM\f\u00170\u00133\u0016\u0003q\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002y\u00051A/\u00197lKJ,\u0012\u0001\u001f\t\u0003+fL!A_\u0013\u0003\u000f\r{g\u000e^1di\u0006a1m\u001c8wKJ\u001c\u0018\r^5p]V\tQ\u0010\u0005\u0002V}&\u0011q0\n\u0002\r\u0007>tg/\u001a:tCRLwN\\\u0001\u000eCN\u001cXM\u001d;QCfdw.\u00193\u0015\u0005\u0005\u0015\u0001c\u0001\u0017\u0002\b%\u0019\u0011\u0011B\u0017\u0003\tUs\u0017\u000e^\u0001\u0005MJ|W.\u0001\u0002u_\u0006!!o\\8n+\t\t\u0019\u0002E\u0003-\u0003+\tI\"C\u0002\u0002\u00185\u0012aa\u00149uS>t\u0007cA+\u0002\u001c%\u0019\u0011QD\u0013\u0003\tI{w.\\\u0001\u0005i\u0016DH/\u0001\u0006u_J+7-\u00197mK\u0012,\u0012\u0001V\u0001\u0004g\u0006LHc\u0001+\u0002*!1\u0011qD\tA\u0002q\"2\u0001VA\u0017\u0011\u0019\tyC\u0005a\u0001q\u000691m\u001c8uC\u000e$Hc\u0001+\u00024!9\u0011QG\nA\u0002\u0005]\u0012a\u0003:fg>,(oY3C_b\u00042aZA\u001d\u0013\r\tY\u0004\u001b\u0002\f%\u0016\u001cx.\u001e:dK\n{\u0007\u0010F\u0002U\u0003\u007fAq!!\u0011\u0015\u0001\u0004\t\u0019%A\u0004ve2d\u0015N\\6\u0011\u0007U\u000b)%C\u0002\u0002H\u0015\u0012q!\u0016:m\u0019&t7\u000eF\u0002U\u0003\u0017Bq!!\u0014\u0016\u0001\u0004\ty%\u0001\u0002naB\u0019Q+!\u0015\n\u0007\u0005MSEA\u0006NS:L\u0007K]8he\u0006l\u0017A\u0002:fG\u0006dG\u000e\u0006\u0002\u0002ZA\u0019A&a\u0017\n\u0007\u0005uSFA\u0004C_>dW-\u00198\u0002\tQL\b/Z\u000b\u0003\u0003G\u0002B!!\u001a\u0002t9!\u0011qMA8\u001d\r\tI\u0007\u001c\b\u0004\u0003WRgb\u0001&\u0002n%\u0011\u0011nJ\u0005\u0004\u0003c\n\u0018aC'fgN\fw-\u001a+za\u0016LA!!\u001e\u0002x\t!A+\u001f9f\u0015\r\t\t(]\u0001\u0005g\u0016dg-A\u0006nK:$\u0018n\u001c8MSN$XCAA@!\u0011a\u0013\u0011\u0011=\n\u0007\u0005\rUFA\u0003BeJ\f\u00170A\u0006nK:$\u0018n\u001c8UKb$\u0018aC7f]RLwN\\*fY\u001a\fqAZ8so\u0006\u0014H\r\u0006\u0003\u0002\u0006\u00055\u0005BBA\u00079\u0001\u0007Q0\u0001\u0003eCR,WCAAJ!\u0011\t)*a'\u000e\u0005\u0005]%bAAM=\u0006!Q\u000f^5m\u0013\u0011\ti*a&\u0003\t\u0011\u000bG/Z\u0001\u0004C\u001e,WCAAR!\ra\u0013QU\u0005\u0004\u0003Ok#\u0001\u0002'p]\u001e\fQ\u0002^8SKN|WO]2f\u0005>DHCAA\u001c\u0003\u001d!x.S7bO\u0016$\"!!-\u0011\u0007U\u000b\u0019,C\u0002\u00026\u0016\u0012Q!S7bO\u0016\f\u0011\u0002^8D_:$\u0018m\u0019;\u0015\u0003a\f\u0011\u0002^8Ve2d\u0015N\\6\u0015\u0005\u0005\r\u0013!\u0004;p\u001b&t\u0017\u000e\u0015:pOJ\fW\u000e\u0006\u0002\u0002P\u0001")
public class Message
implements LazyLogging {
    private Message.MessagePayload payload;
    private final String messageId;
    private final Wechaty.PuppetResolver resolver;
    private final String MENTION_MEMBER_PATTERN;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Message message = this;
        synchronized (message) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private String MENTION_MEMBER_PATTERN() {
        return this.MENTION_MEMBER_PATTERN;
    }

    private Message.MessagePayload payload$lzycompute() {
        Message message = this;
        synchronized (message) {
            if (!this.bitmap$0) {
                this.payload = this.resolver.puppet().messagePayload(this.messageId);
                this.bitmap$0 = true;
            }
        }
        return this.payload;
    }

    public Message.MessagePayload payload() {
        return !this.bitmap$0 ? this.payload$lzycompute() : this.payload;
    }

    private String sayId() {
        String string;
        if (!Puppet$.MODULE$.isBlank(this.payload().roomId())) {
            string = this.payload().roomId();
        } else if (!Puppet$.MODULE$.isBlank(this.payload().fromId())) {
            string = this.payload().fromId();
        } else {
            throw new IllegalStateException("roomid and fromid both is null");
        }
        return string;
    }

    public String toString() {
        return this.payload() != null ? this.payload().text() : "Message";
    }

    public Contact talker() {
        return this.from();
    }

    public Conversation conversation() {
        Conversation conversation;
        Option<Room> option = this.room();
        if (option instanceof Some) {
            Some some = (Some)option;
            Room r = (Room)some.value();
            conversation = r;
        } else {
            conversation = this.from();
        }
        return conversation;
    }

    private void assertPayload() {
        if (this.payload() == null) {
            throw new Error("no payload");
        }
    }

    public Contact from() {
        this.assertPayload();
        String fromId = this.payload().fromId();
        return Puppet$.MODULE$.isBlank(fromId) ? null : new Contact(fromId, this.resolver);
    }

    public Contact to() {
        this.assertPayload();
        String toId = this.payload().toId();
        return Puppet$.MODULE$.isBlank(toId) ? null : new Contact(toId, this.resolver);
    }

    public Option<Room> room() {
        this.assertPayload();
        String roomId = this.payload().roomId();
        return Puppet$.MODULE$.isBlank(roomId) ? None$.MODULE$ : Room$.MODULE$.load(roomId, this.resolver);
    }

    public String text() {
        this.assertPayload();
        return this.payload().text();
    }

    public Message toRecalled() {
        Enumeration.Value value = this.type();
        Enumeration.Value value2 = Message.MessageType$.MODULE$.Recalled();
        if (value == null ? value2 != null : !value.equals(value2)) {
            throw new Error("Can not call toRecalled() on message which is not recalled type.");
        }
        String originalMessageId = this.text();
        if (originalMessageId == null) {
            throw new Error("Can not find recalled message");
        }
        return new Message(originalMessageId, this.resolver);
    }

    public Message say(String text) {
        Puppet qual$1 = this.resolver.puppet();
        String x$1 = this.sayId();
        String x$2 = text;
        String[] x$3 = qual$1.messageSendText$default$3();
        return ImplicitHelper$.MODULE$.toMessage(qual$1.messageSendText(x$1, x$2, x$3), this.resolver);
    }

    public Message say(Contact contact) {
        return ImplicitHelper$.MODULE$.toMessage(this.resolver.puppet().messageSendContact(this.sayId(), contact.id()), this.resolver);
    }

    public Message say(ResourceBox resourceBox) {
        return ImplicitHelper$.MODULE$.toMessage(this.resolver.puppet().messageSendFile(this.sayId(), resourceBox), this.resolver);
    }

    public Message say(UrlLink urlLink) {
        return ImplicitHelper$.MODULE$.toMessage(this.resolver.puppet().messageSendUrl(this.sayId(), urlLink.payload()), this.resolver);
    }

    public Message say(MiniProgram mp) {
        return ImplicitHelper$.MODULE$.toMessage(this.resolver.puppet().messageSendMiniProgram(this.sayId(), mp.payload()), this.resolver);
    }

    public boolean recall() {
        return this.resolver.puppet().messageRecall(this.messageId);
    }

    public Enumeration.Value type() {
        this.assertPayload();
        return this.payload().type();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean self() {
        Option userIdOpt = this.resolver.puppet().selfIdOpt();
        Option option = userIdOpt;
        if (!(option instanceof Some)) return false;
        Some some = (Some)option;
        String userId = (String)some.value();
        Contact from = this.from();
        if (from == null) return false;
        String string = from.id();
        String string2 = userId;
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public Contact[] mentionList() {
        Contact[] contactArray;
        Option<Room> room = this.room();
        Enumeration.Value value = this.type();
        Enumeration.Value value2 = Message.MessageType$.MODULE$.Text();
        if ((value != null ? !value.equals(value2) : value2 != null) || room == null) {
            return (Contact[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Contact.class));
        }
        if (this.payload() != null && this.payload().mentionIdList() != null && this.payload().mentionIdList().length > 0) {
            contactArray = (Contact[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.payload().mentionIdList())).map((Function1 & Serializable & scala.Serializable)x$1 -> new Contact((String)x$1, $this.resolver), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Contact.class)));
        } else {
            Regex reg = new StringOps(Predef$.MODULE$.augmentString(this.MENTION_MEMBER_PATTERN())).r();
            Iterator it = reg.findAllMatchIn((CharSequence)this.text());
            contactArray = (Contact[])it.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.group(1)).map((Function1 & Serializable & scala.Serializable)x$3 -> new Contact((String)x$3, $this.resolver)).toArray(ClassTag$.MODULE$.apply(Contact.class));
        }
        return contactArray;
    }

    public String mentionText() {
        BoxedUnit boxedUnit;
        String text = this.text();
        Option<Room> room = this.room();
        Contact[] list = this.mentionList();
        if (room.isEmpty() || list == null || list.length == 0) {
            return text;
        }
        Function1 & Serializable & scala.Serializable toAliasName = (Function1 & Serializable & scala.Serializable)member -> (String)((Room)room.get()).alias((Contact)member).getOrElse((Function0 & Serializable & scala.Serializable)() -> member.name());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("message text:{} mentionsList:{}", new Object[]{text, list});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String[] mentionNameList = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list)).map((Function1)toAliasName, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String textWithoutMention = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mentionNameList)).foldLeft((Object)text, (Function2 & Serializable & scala.Serializable)(prev, cur) -> {
            String escapedCur = cur;
            String regex = new StringBuilder(22).append("@\\Q").append(escapedCur).append("\\E(\\u2005|\\u0020|$)").toString();
            return prev.replaceFirst(regex, "");
        });
        return textWithoutMention.trim();
    }

    public boolean mentionSelf() {
        boolean bl;
        Option option = this.resolver.puppet().selfIdOpt();
        if (option instanceof Some) {
            Some some = (Some)option;
            String selfId = (String)some.value();
            bl = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.mentionList())).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Message.$anonfun$mentionSelf$1(selfId, x$4)));
        } else {
            bl = false;
        }
        return bl;
    }

    public void forward(Conversation to) {
        this.resolver.puppet().messageForward(to.id(), this.messageId);
    }

    public Date date() {
        this.assertPayload();
        long timestamp = this.payload().timestamp();
        return Puppet$.MODULE$.timestampToDate(timestamp);
    }

    public long age() {
        long ageMilliseconds = System.currentTimeMillis() - this.date().getTime();
        double ageSeconds = Math.floor(ageMilliseconds / 1000L);
        return Predef$.MODULE$.double2Double(ageSeconds).longValue();
    }

    public ResourceBox toResourceBox() {
        Enumeration.Value value = this.type();
        Enumeration.Value value2 = Message.MessageType$.MODULE$.Text();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            throw new Error("text message no file");
        }
        return this.resolver.puppet().messageFile(this.messageId);
    }

    public Image toImage() {
        Enumeration.Value value = this.type();
        Enumeration.Value value2 = Message.MessageType$.MODULE$.Image();
        if (value == null ? value2 != null : !value.equals(value2)) {
            throw new Error(new StringBuilder(32).append("not a image type message. type: ").append(this.type()).toString());
        }
        return new Image(this.messageId, this.resolver);
    }

    public Contact toContact() {
        Enumeration.Value value = this.type();
        Enumeration.Value value2 = Message.MessageType$.MODULE$.Contact();
        if (value == null ? value2 != null : !value.equals(value2)) {
            throw new Error("message not a ShareCard");
        }
        String contactId = this.resolver.puppet().messageContact(this.messageId);
        if (Puppet$.MODULE$.isBlank(contactId)) {
            throw new Error(new StringBuilder(35).append("can not get Contact id by message: ").append(contactId).toString());
        }
        return new Contact(contactId, this.resolver);
    }

    public UrlLink toUrlLink() {
        this.assertPayload();
        Enumeration.Value value = this.type();
        Enumeration.Value value2 = Message.MessageType$.MODULE$.Url();
        if (value == null ? value2 != null : !value.equals(value2)) {
            throw new Error("message not a Url Link");
        }
        UrlLink.UrlLinkPayload urlPayload = this.resolver.puppet().messageUrl(this.messageId);
        if (urlPayload == null) {
            throw new Error(new StringBuilder(27).append("no url payload for message ").append(this.messageId).toString());
        }
        return new UrlLink(urlPayload);
    }

    public MiniProgram toMiniProgram() {
        this.assertPayload();
        Enumeration.Value value = this.type();
        Enumeration.Value value2 = Message.MessageType$.MODULE$.MiniProgram();
        if (value == null ? value2 != null : !value.equals(value2)) {
            throw new Error("message not a MiniProgram");
        }
        MiniProgram.MiniProgramPayload miniProgramPayload = this.resolver.puppet().messageMiniProgram(this.messageId);
        if (miniProgramPayload == null) {
            throw new Error(new StringBuilder(35).append("no miniProgram payload for message ").append(this.messageId).toString());
        }
        return new MiniProgram(miniProgramPayload);
    }

    public static final /* synthetic */ boolean $anonfun$mentionSelf$1(String selfId$1, Contact x$4) {
        String string = x$4.id();
        String string2 = selfId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public Message(String messageId, Wechaty.PuppetResolver resolver) {
        this.messageId = messageId;
        this.resolver = resolver;
        LazyLogging.$init$((LazyLogging)this);
        this.MENTION_MEMBER_PATTERN = "@([^\u2005^ ^$]+)";
    }
}

