/*
 * Decompiled with CFR 0.152.
 */
package wechaty.user;

import java.io.Serializable;
import java.util.Date;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import wechaty.Wechaty;
import wechaty.puppet.schemas.Event;
import wechaty.puppet.schemas.Puppet;
import wechaty.puppet.schemas.Puppet$;
import wechaty.puppet.schemas.Room;
import wechaty.user.Contact;
import wechaty.user.Message;
import wechaty.user.Room;

public final class Room$ {
    public static Room$ MODULE$;
    private Map<String, Room> pool;

    static {
        new Room$();
    }

    private Map<String, Room> pool() {
        return this.pool;
    }

    private void pool_$eq(Map<String, Room> x$1) {
        this.pool = x$1;
    }

    public Room create(Contact[] contactList, String topic, Wechaty.PuppetResolver puppetResolver) {
        if (contactList.length < 2) {
            throw new Error("contactList need at least 2 contact to create a new room");
        }
        String[] contactIdList = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])contactList)).map((Function1 & Serializable & scala.Serializable)contact -> contact.id(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String roomId = puppetResolver.puppet().roomCreate(contactIdList, topic);
        return new Room(roomId, puppetResolver);
    }

    public Option<Room> load(String roomId, Wechaty.PuppetResolver puppetResolver) {
        Some some;
        Option option = this.pool().get((Object)roomId);
        if (option instanceof Some) {
            Some some2 = (Some)option;
            Room room = (Room)some2.value();
            some = new Some((Object)room);
        } else {
            Room newRoom = new Room(roomId, puppetResolver);
            this.pool_$eq((Map<String, Room>)this.pool().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)roomId), (Object)newRoom)));
            some = new Some((Object)newRoom);
        }
        return some;
    }

    public void clear() {
        this.pool_$eq((Map<String, Room>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
    }

    public void messageEvent(Event.EventMessagePayload messagePayload, Wechaty.PuppetResolver resolver) {
        Message message = new Message(messagePayload.messageId(), resolver);
        Option<Room> roomOpt = message.room();
        roomOpt.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.emit(Puppet.PuppetEventName$.MODULE$.MESSAGE(), message);
            return BoxedUnit.UNIT;
        });
    }

    public void roomJoinEvent(Event.EventRoomJoinPayload payload, Wechaty.PuppetResolver resolver) {
        Room room = (Room)this.load(payload.roomId(), resolver).get();
        Contact[] inviteeList = (Contact[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])payload.inviteeIdList())).map((Function1 & Serializable & scala.Serializable)id -> new Contact((String)id, resolver), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Contact.class)));
        Contact inviter = new Contact(payload.inviterId(), resolver);
        Date date = Puppet$.MODULE$.timestampToDate(payload.timestamp());
        room.emit(Puppet.PuppetEventName$.MODULE$.ROOM_JOIN(), new Tuple3((Object)inviteeList, (Object)inviter, (Object)date));
    }

    public void roomLeaveEvent(Event.EventRoomLeavePayload payload, Wechaty.PuppetResolver resolver) {
        Option userIdOpt;
        Room room = (Room)this.load(payload.roomId(), resolver).get();
        Contact[] leaverList = (Contact[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])payload.removeeIdList())).map((Function1 & Serializable & scala.Serializable)id -> new Contact((String)id, resolver), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Contact.class)));
        Contact remover = new Contact(payload.removerId(), resolver);
        Date date = Puppet$.MODULE$.timestampToDate(payload.timestamp());
        room.emit(Puppet.PuppetEventName$.MODULE$.ROOM_LEAVE(), new Tuple3((Object)leaverList, (Object)remover, (Object)date));
        Option option = userIdOpt = resolver.puppet().selfIdOpt();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            String userId = (String)some.value();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leaverList)).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Room$.$anonfun$roomLeaveEvent$2(userId, x$2)))) {
                resolver.puppet().roomPayloadDirty(payload.roomId());
                resolver.puppet().roomMemberPayloadDirty(payload.roomId());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void roomTopicEvent(Event.EventRoomTopicPayload payload, Wechaty.PuppetResolver resolver) {
        Room room = (Room)this.load(payload.roomId(), resolver).get();
        Contact changer = new Contact(payload.changerId(), resolver);
        Date date = Puppet$.MODULE$.timestampToDate(payload.timestamp());
        room.emit(Puppet.PuppetEventName$.MODULE$.ROOM_TOPIC(), new Tuple2((Object)changer, (Object)date));
    }

    public Room[] findAll(Option<Function1<Room.RoomPayload, Object>> query, Wechaty.PuppetResolver resolver) {
        String[] roomIdList = resolver.puppet().roomSearch(query);
        return (Room[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])roomIdList)).flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(MODULE$.load((String)id, resolver)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Room.class)));
    }

    public Option<Room> find(Option<Function1<Room.RoomPayload, Object>> query, Wechaty.PuppetResolver resolver) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.findAll(query, resolver))).headOption();
    }

    public Option<Room> find(Function1<Room.RoomPayload, Object> query, Wechaty.PuppetResolver resolver) {
        return this.find((Option<Function1<Room.RoomPayload, Object>>)new Some(query), resolver);
    }

    public Option<Function1<Room.RoomPayload, Object>> findAll$default$1() {
        return None$.MODULE$;
    }

    public Option<Function1<Room.RoomPayload, Object>> find$default$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$roomLeaveEvent$2(String userId$1, Contact x$2) {
        String string = x$2.id();
        String string2 = userId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Room$() {
        MODULE$ = this;
        this.pool = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }
}

