package androiddemo;

import com.cloudtestapi.CTClient;
import com.cloudtestapi.account.models.Cloud;
import com.cloudtestapi.account.models.Project;
import com.cloudtestapi.common.Constants;
import com.cloudtestapi.common.Credential;
import com.cloudtestapi.common.profile.ClientProfile;
import com.cloudtestapi.common.profile.HttpProfile;
import com.cloudtestapi.device.models.Device;
import com.cloudtestapi.device.models.DeviceBasicInfo;
import com.cloudtestapi.device.models.GetDevicesResponse;
import com.cloudtestapi.slot.models.ModelInfo;
import com.cloudtestapi.slot.models.SlotSwitchStartRequest;
import com.cloudtestapi.test.models.*;
import com.cloudtestapi.upload.models.App;

public class AndroidDemoProgram {


    public static Device chooseFreeDevice(Device[] devices) {
        for (Device d :
                devices) {
            if (d.deviceStateCode == Constants.DeviceState.FREE) {
                return d;
            }
        }
        return null;
    }


    public static void testAndroid(CTClient client) throws Exception {
        // 1.1 获取用户项目列表
        Project[] projects = client.account.getProjects();
        System.out.println(client.gson.toJson(projects));
        // 1.2 通过项目名称获取项目信息
        Project project = client.account.getProjectByName("uftm");
        System.out.println(client.gson.toJson(project));
        // 2.1 获取用户拥有权限的云
        Cloud[] clouds = client.account.getClouds();
        System.out.println(client.gson.toJson(clouds));
        // 2.2 通过云名称获取云信息
        Cloud cloud = client.account.getCloudByName("UFT专有云");
        System.out.println(client.gson.toJson(cloud));
        // 3. 获取指定云权限下的设备列表
        GetDevicesResponse devicesResp = client.device.getDevicesByCloudId(cloud.cloudId);
        System.out.println(client.gson.toJson(devicesResp.devices));
        // 4. 筛选一个空闲设备
        Device freeDevice = chooseFreeDevice(devicesResp.devices);
        System.out.println("选择空闲设备 " + client.gson.toJson(freeDevice));
        // 5. 开启远程调试，占用设备
        DebugTestInfo testInfo = client.test.startDebugTest(freeDevice.deviceID, project.keyName);
        System.out.println(client.gson.toJson(testInfo));
        // 6. 开启 wdb 远程调试 &&  7. 获取 wdb 连接地址和秘钥 , 合并
        StartDebugConnectResponse connectResponse = client.test.startRemoteDebugConnect(testInfo.testId, freeDevice.deviceID);
        System.out.println(client.gson.toJson(connectResponse));
        // 8. 执行本地wdb connect 地址和密码
        // FIXME: 待终端实现
        client.device.wdbConnect(connectResponse.debugStatus.addr, connectResponse.debugStatus.token, 10);
        // 9. 上传 & 安装apk & 轮询安装状态
        App app =  client.upload.uploadApp("test.apk");
        System.out.println(client.gson.toJson(app));
        InstallAppResponse install = client.test.installApp(testInfo.testId, freeDevice.deviceID, app.appId, true);
        System.out.println(client.gson.toJson(install));
        while (true) {
            GetInstallProcessResponse resp = client.test.getInstallProcess(testInfo.testId,
                    freeDevice.deviceID, install.installInfo.install_id);
            System.out.println(client.gson.toJson(resp));
            if(resp.installInfo.progress == Constants.InstallProgress.DOWNLOADING) {
                System.out.println("下载中.....");
            } else if(resp.installInfo.progress == Constants.InstallProgress.PUSHING) {
                System.out.println("推送中.....");
            } else if(resp.installInfo.progress == Constants.InstallProgress.INSTALLING) {
                System.out.println("安装中.....");
            }
            if(resp.installInfo.result > 100) {
                System.out.println("安装失败：" + resp.installInfo.msg);
                break;
            } else if(resp.installInfo.result == 100) {
                System.out.println("安装完成");
                break;
            }  else {
                System.out.println(String.format("安装进度 %d", resp.installInfo.result));
            }
            Thread.sleep(2000);
        }
        // 9. 5秒后，释放设备
        Thread.sleep(5000);
        System.out.println("----释放设备-----");
       client.test.cancelTest(testInfo.testId);
    }


    public static void main(String[] args) throws  Exception {
        // MF
        String secretId = "e6d138fb86714c0cb32ad94e9f7abbbe";
        String secretKey = "c96jpicn01bm1h6eblq0";
        // AKON
//        String secretId = "8954cf7a0c4d45ad9ff6f14ede9295be";
//        String secretKey = "c1q5t7cn01bn7pck7vm0";
        // Cy
//        String secretId = "9cd8a8af66414fd981938f3e2791caae";
//        String secretKey = "cc2pc97bu5bg87icqt40";
        // 初始化客户端调用配置
        CTClient client = new CTClient(
                new Credential(secretId,
                        secretKey),
                new ClientProfile(ClientProfile.SIGN_SHA256,
                        new HttpProfile()
                        .setRootDomain("api.paas.wetest.qq.com")
                        .setToolPath("cloudtest")
                        .setProtocol(HttpProfile.REQ_HTTPS)
                        )
        );

        System.out.println(client.gson.toJson(client.slot.slotListInfo("")));
//        System.out.println(client.gson.toJson(client.device.getDevicesByCloudId(2)));
    }
}
