/*
 * Decompiled with CFR 0.152.
 */
package androiddemo;

import com.cloudtestapi.CTClient;
import com.cloudtestapi.account.models.Cloud;
import com.cloudtestapi.account.models.Project;
import com.cloudtestapi.common.Constants;
import com.cloudtestapi.common.Credential;
import com.cloudtestapi.common.profile.ClientProfile;
import com.cloudtestapi.common.profile.HttpProfile;
import com.cloudtestapi.device.models.Device;
import com.cloudtestapi.device.models.GetDevicesResponse;
import com.cloudtestapi.test.models.DebugTestInfo;
import com.cloudtestapi.test.models.GetInstallProcessResponse;
import com.cloudtestapi.test.models.InstallAppResponse;
import com.cloudtestapi.test.models.StartDebugConnectResponse;
import com.cloudtestapi.upload.models.App;

public class AndroidDemoProgram {
    public static Device chooseFreeDevice(Device[] devices) {
        for (Device d : devices) {
            if (d.deviceStateCode != Constants.DeviceState.FREE) continue;
            return d;
        }
        return null;
    }

    public static void testAndroid(CTClient client) throws Exception {
        Project[] projects = client.account.getProjects();
        System.out.println(client.gson.toJson((Object)projects));
        Project project = client.account.getProjectByName("uftm");
        System.out.println(client.gson.toJson((Object)project));
        Cloud[] clouds = client.account.getClouds();
        System.out.println(client.gson.toJson((Object)clouds));
        Cloud cloud = client.account.getCloudByName("UFT\u4e13\u6709\u4e91");
        System.out.println(client.gson.toJson((Object)cloud));
        GetDevicesResponse devicesResp = client.device.getDevicesByCloudId(cloud.cloudId);
        System.out.println(client.gson.toJson((Object)devicesResp.devices));
        Device freeDevice = AndroidDemoProgram.chooseFreeDevice(devicesResp.devices);
        System.out.println("\u9009\u62e9\u7a7a\u95f2\u8bbe\u5907 " + client.gson.toJson((Object)freeDevice));
        DebugTestInfo testInfo = client.test.startDebugTest(freeDevice.deviceID, project.keyName);
        System.out.println(client.gson.toJson((Object)testInfo));
        StartDebugConnectResponse connectResponse = client.test.startRemoteDebugConnect(testInfo.testId, freeDevice.deviceID);
        System.out.println(client.gson.toJson((Object)connectResponse));
        client.device.wdbConnect(connectResponse.debugStatus.addr, connectResponse.debugStatus.token, 10);
        App app = client.upload.uploadApp("test.apk");
        System.out.println(client.gson.toJson((Object)app));
        InstallAppResponse install = client.test.installApp(testInfo.testId, freeDevice.deviceID, app.appId, true);
        System.out.println(client.gson.toJson((Object)install));
        while (true) {
            GetInstallProcessResponse resp = client.test.getInstallProcess(testInfo.testId, freeDevice.deviceID, install.installInfo.install_id);
            System.out.println(client.gson.toJson((Object)resp));
            if (resp.installInfo.progress == Constants.InstallProgress.DOWNLOADING) {
                System.out.println("\u4e0b\u8f7d\u4e2d.....");
            } else if (resp.installInfo.progress == Constants.InstallProgress.PUSHING) {
                System.out.println("\u63a8\u9001\u4e2d.....");
            } else if (resp.installInfo.progress == Constants.InstallProgress.INSTALLING) {
                System.out.println("\u5b89\u88c5\u4e2d.....");
            }
            if (resp.installInfo.result > 100) {
                System.out.println("\u5b89\u88c5\u5931\u8d25\uff1a" + resp.installInfo.msg);
                break;
            }
            if (resp.installInfo.result == 100) {
                System.out.println("\u5b89\u88c5\u5b8c\u6210");
                break;
            }
            System.out.println(String.format("\u5b89\u88c5\u8fdb\u5ea6 %d", resp.installInfo.result));
            Thread.sleep(2000L);
        }
        Thread.sleep(5000L);
        System.out.println("----\u91ca\u653e\u8bbe\u5907-----");
        client.test.cancelTest(testInfo.testId);
    }

    public static void main(String[] args) throws Exception {
        String secretId = "e6d138fb86714c0cb32ad94e9f7abbbe";
        String secretKey = "c96jpicn01bm1h6eblq0";
        CTClient client = new CTClient(new Credential(secretId, secretKey), new ClientProfile("HmacSHA256", new HttpProfile().setRootDomain("api.paas.wetest.qq.com").setToolPath("cloudtest").setProtocol("https://")));
        System.out.println(client.gson.toJson((Object)client.slot.slotListInfo("")));
    }
}

