/*
 * Decompiled with CFR 0.152.
 */
package com.cloudtestapi.common;

import com.cloudtestapi.common.exception.CloudTestSDKException;
import java.io.IOException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpConnection {
    private OkHttpClient.Builder client;

    public HttpConnection(Integer connTimeout, Integer readTimeout, Integer writeTimeout) {
        this.client = new OkHttpClient.Builder().connectTimeout((long)connTimeout.intValue(), TimeUnit.SECONDS).readTimeout((long)readTimeout.intValue(), TimeUnit.SECONDS).writeTimeout((long)writeTimeout.intValue(), TimeUnit.SECONDS);
    }

    public void addInterceptors(Interceptor interceptor) {
        this.client.interceptors().add(interceptor);
    }

    public void setProxy(Proxy proxy) {
        this.client.proxy(proxy);
    }

    public void setProxyAuthenticator(Authenticator authenticator) {
        this.client.proxyAuthenticator(authenticator);
    }

    public Response doRequest(Request request) throws CloudTestSDKException {
        Response response = null;
        try {
            response = this.client.build().newCall(request).execute();
        }
        catch (IOException e) {
            throw new CloudTestSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return response;
    }

    public Response getRequest(String url) throws CloudTestSDKException {
        Request request = null;
        try {
            request = new Request.Builder().url(url).get().build();
        }
        catch (IllegalArgumentException e) {
            throw new CloudTestSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response deleteRequest(String url) throws CloudTestSDKException {
        Request request = null;
        try {
            request = new Request.Builder().url(url).delete().build();
        }
        catch (IllegalArgumentException e) {
            throw new CloudTestSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response postRequest(String url, byte[] body) throws CloudTestSDKException {
        MediaType contentType = MediaType.parse((String)"application/json");
        Request request = null;
        try {
            request = new Request.Builder().url(url).post(RequestBody.create((MediaType)contentType, (byte[])body)).build();
        }
        catch (IllegalArgumentException e) {
            throw new CloudTestSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response putRequest(String url, byte[] body) throws CloudTestSDKException {
        MediaType contentType = MediaType.parse((String)"application/json");
        Request request = null;
        try {
            request = new Request.Builder().url(url).put(RequestBody.create((MediaType)contentType, (byte[])body)).build();
        }
        catch (IllegalArgumentException e) {
            throw new CloudTestSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response postFormRequest(String url, byte[] body, String fieldName, String fileName, String fileMime) throws CloudTestSDKException {
        Request request;
        try {
            MultipartBody requestBody = new MultipartBody.Builder().setType(MediaType.parse((String)"multipart/form-data")).addFormDataPart(fieldName, fileName, RequestBody.create((MediaType)MediaType.parse((String)fileMime), (byte[])body)).build();
            request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        }
        catch (IllegalArgumentException e) {
            throw new CloudTestSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }

    public Response postRequest(String url, byte[] body, Headers headers) throws CloudTestSDKException {
        MediaType contentType = MediaType.parse((String)headers.get("Content-Type"));
        Request request = null;
        try {
            request = new Request.Builder().url(url).post(RequestBody.create((MediaType)contentType, (byte[])body)).headers(headers).build();
        }
        catch (IllegalArgumentException e) {
            throw new CloudTestSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        return this.doRequest(request);
    }
}

