/*
 * Decompiled with CFR 0.152.
 */
package com.cloudtestapi.slot;

import com.cloudtestapi.common.AbstractClient;
import com.cloudtestapi.common.Credential;
import com.cloudtestapi.common.JsonResponseModel;
import com.cloudtestapi.common.exception.CloudTestSDKException;
import com.cloudtestapi.common.profile.ClientProfile;
import com.cloudtestapi.slot.models.FetchResignResultRequest;
import com.cloudtestapi.slot.models.ModelInfo;
import com.cloudtestapi.slot.models.ResignIpaRequest;
import com.cloudtestapi.slot.models.ResignIpaResponse;
import com.cloudtestapi.slot.models.ResignResult;
import com.cloudtestapi.slot.models.SlotDeviceInfo;
import com.cloudtestapi.slot.models.SlotInfo;
import com.cloudtestapi.slot.models.SlotListDeviceRequest;
import com.cloudtestapi.slot.models.SlotListDeviceResponse;
import com.cloudtestapi.slot.models.SlotListInfoRequest;
import com.cloudtestapi.slot.models.SlotListInfoResponse;
import com.cloudtestapi.slot.models.SlotListModelRequest;
import com.cloudtestapi.slot.models.SlotListModelResponse;
import com.cloudtestapi.slot.models.SlotSwitchCancelRequest;
import com.cloudtestapi.slot.models.SlotSwitchStartRequest;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;

public class SlotClient
extends AbstractClient {
    public SlotClient(Credential credential) {
        this(credential, new ClientProfile());
    }

    public SlotClient(Credential credential, ClientProfile clientProfile) {
        super(credential, clientProfile);
    }

    public SlotInfo[] slotListInfo(String slotOutAddr) throws CloudTestSDKException {
        JsonResponseModel rsp = null;
        SlotListInfoRequest request = new SlotListInfoRequest();
        request.setSlotOutAddr(slotOutAddr);
        String rspStr = "";
        try {
            Type type = new TypeToken<JsonResponseModel<SlotListInfoResponse>>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (JsonResponseModel)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return ((SlotListInfoResponse)rsp.data).list;
    }

    public ModelInfo[] slotListModel(int[] phoneTypeList) throws CloudTestSDKException {
        JsonResponseModel rsp = null;
        SlotListModelRequest request = new SlotListModelRequest();
        request.setPhoneTypeList(phoneTypeList);
        String rspStr = "";
        try {
            Type type = new TypeToken<JsonResponseModel<SlotListModelResponse>>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (JsonResponseModel)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return ((SlotListModelResponse)rsp.data).list;
    }

    public SlotDeviceInfo[] slotListDevice(int[] phoneTypeList) throws CloudTestSDKException {
        JsonResponseModel rsp = null;
        SlotListDeviceRequest request = new SlotListDeviceRequest();
        request.setPhoneTypeList(phoneTypeList);
        String rspStr = "";
        try {
            Type type = new TypeToken<JsonResponseModel<SlotListDeviceResponse>>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (JsonResponseModel)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return ((SlotListDeviceResponse)rsp.data).list;
    }

    public void slotSwitchStart(String slotOutAddr, int modelId, int deviceId) throws CloudTestSDKException {
        SlotSwitchStartRequest request = new SlotSwitchStartRequest();
        request.setModelId(modelId);
        request.setDeviceId(deviceId);
        request.setSlotOutAddr(slotOutAddr);
        this.internalRequest(request);
    }

    public void slotSwitchCancel(String slotOutAddr) throws CloudTestSDKException {
        SlotSwitchCancelRequest request = new SlotSwitchCancelRequest();
        request.setSlotOutAddr(slotOutAddr);
        this.internalRequest(request);
    }

    public String resignIpa(String slotOutAddr, String fileUrl) throws CloudTestSDKException {
        ResignIpaRequest request = new ResignIpaRequest();
        request.setSlotOutAddr(slotOutAddr);
        request.setFileUrl(fileUrl);
        JsonResponseModel rsp = null;
        String rspStr = "";
        try {
            Type type = new TypeToken<JsonResponseModel<ResignIpaResponse>>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (JsonResponseModel)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return ((ResignIpaResponse)rsp.data).fileId;
    }

    public ResignResult fetchResignResult(String slotOutAddr, String fileId) throws CloudTestSDKException {
        FetchResignResultRequest request = new FetchResignResultRequest();
        request.setFileId(fileId);
        request.setSlotOutAddr(slotOutAddr);
        JsonResponseModel rsp = null;
        String rspStr = "";
        try {
            Type type = new TypeToken<JsonResponseModel<ResignResult>>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (JsonResponseModel)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return (ResignResult)rsp.data;
    }
}

