/*
 * Decompiled with CFR 0.152.
 */
package com.cloudtestapi.account;

import com.cloudtestapi.account.models.Cloud;
import com.cloudtestapi.account.models.GetUserCloudsRequest;
import com.cloudtestapi.account.models.GetUserCloudsResponse;
import com.cloudtestapi.account.models.GetUserProjectRequest;
import com.cloudtestapi.account.models.GetUserProjectResponse;
import com.cloudtestapi.account.models.Project;
import com.cloudtestapi.common.AbstractClient;
import com.cloudtestapi.common.Credential;
import com.cloudtestapi.common.exception.CloudTestSDKException;
import com.cloudtestapi.common.profile.ClientProfile;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;

public class AccountClient
extends AbstractClient {
    public AccountClient(Credential credential) {
        this(credential, new ClientProfile());
    }

    public AccountClient(Credential credential, ClientProfile clientProfile) {
        super(credential, clientProfile);
    }

    public Project[] getProjects() throws CloudTestSDKException {
        GetUserProjectResponse rsp;
        GetUserProjectRequest request = new GetUserProjectRequest();
        String rspStr = "";
        try {
            Type type = new TypeToken<GetUserProjectResponse>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (GetUserProjectResponse)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return rsp.projects;
    }

    public Project getProjectByName(String projectName) throws CloudTestSDKException {
        Project[] projects;
        for (Project p : projects = this.getProjects()) {
            if (!p.projectName.equals(projectName)) continue;
            return p;
        }
        return null;
    }

    public Cloud[] getClouds() throws CloudTestSDKException {
        GetUserCloudsResponse rsp;
        GetUserCloudsRequest request = new GetUserCloudsRequest();
        String rspStr = "";
        try {
            Type type = new TypeToken<GetUserCloudsResponse>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (GetUserCloudsResponse)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return rsp.clouds;
    }

    public Cloud getCloudByName(String cloudName) throws CloudTestSDKException {
        Cloud[] clouds;
        for (Cloud c : clouds = this.getClouds()) {
            if (!c.cloudName.equals(cloudName)) continue;
            return c;
        }
        return null;
    }
}

