/*
 * Decompiled with CFR 0.152.
 */
package com.cloudtestapi.common;

import com.cloudtestapi.common.AbstractRequest;
import com.cloudtestapi.common.AbstractUploadRequest;
import com.cloudtestapi.common.Credential;
import com.cloudtestapi.common.HttpConnection;
import com.cloudtestapi.common.JsonResponseErrModel;
import com.cloudtestapi.common.Sign;
import com.cloudtestapi.common.TCLog;
import com.cloudtestapi.common.exception.CloudTestSDKException;
import com.cloudtestapi.common.profile.ClientProfile;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.net.ssl.SSLContext;
import okhttp3.Credentials;
import okhttp3.Response;
import org.apache.commons.logging.Log;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class AbstractClient {
    public static final int HTTP_RSP_OK = 200;
    public Gson gson;
    private Credential credential;
    private ClientProfile profile;
    private TCLog log;
    private boolean authed;

    public AbstractClient(Credential credential, ClientProfile clientProfile) {
        this.credential = credential;
        this.profile = clientProfile;
        this.gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        this.log = new TCLog(this.getClass().getName(), this.profile.isDebug());
        this.authed = false;
        this.warmup();
    }

    protected String internalRequest(AbstractRequest request) throws CloudTestSDKException {
        String sm = this.profile.getSignMethod();
        if (!sm.equals("HmacSHA1") && !sm.equals("HmacSHA256")) {
            throw new CloudTestSDKException("Signature method " + sm + " is invalid or not supported yet.");
        }
        Response okRsp = this.doRequest(request);
        return this.parseErrorFromResponse(okRsp);
    }

    private String parseErrorFromResponse(Response okRsp) throws CloudTestSDKException {
        JsonResponseErrModel errResp;
        String respBody;
        try {
            respBody = okRsp.body().string();
        }
        catch (IOException e) {
            String msg = "Cannot transfer response body to string, because Content-Length is too large, or Content-Length and stream length disagree.";
            this.log.getLogger().info((Object)msg);
            throw new CloudTestSDKException(msg);
        }
        if (okRsp.code() != 200) {
            String msg = "response code is " + okRsp.code() + ", not 200";
            this.log.info(msg);
            this.log.info("resp body:" + respBody);
            throw new CloudTestSDKException(msg);
        }
        try {
            Type errType = new TypeToken<JsonResponseErrModel>(){}.getType();
            errResp = (JsonResponseErrModel)this.gson.fromJson(respBody, errType);
        }
        catch (JsonSyntaxException e) {
            String msg = "json is not a valid representation for an object of type";
            this.log.info(msg);
            throw new CloudTestSDKException(msg);
        }
        if (errResp != null && errResp.code != null && errResp.code != 0 && errResp.code != 1) {
            throw new CloudTestSDKException(errResp.message + ";" + errResp.msg, errResp.code, errResp.traceId);
        }
        return respBody;
    }

    private Response doRequest(AbstractRequest request) throws CloudTestSDKException {
        HashMap<String, String> pathMap = new HashMap<String, String>();
        request.toPathParamMap(pathMap, "");
        String path = request.getPath();
        for (Map.Entry<String, String> entry : pathMap.entrySet()) {
            if ("".equals(entry.getValue())) {
                path = path.replaceAll(entry.getKey() + "/", entry.getValue());
            }
            path = path.replaceAll(entry.getKey(), entry.getValue());
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        request.toQueryParamMap(queryMap, "");
        this.signParam(queryMap, "/" + this.getClientProfile().getHttpProfile().getToolPath() + "/" + request.getVersion() + path, request.getHttpMethod());
        HttpConnection conn = new HttpConnection(this.profile.getHttpProfile().getConnTimeout(), this.profile.getHttpProfile().getReadTimeout(), this.profile.getHttpProfile().getWriteTimeout());
        conn.addInterceptors(this.log);
        this.trySetProxy(conn);
        String reqMethod = request.getHttpMethod();
        if ("".equals(reqMethod)) {
            reqMethod = this.profile.getHttpProfile().getReqMethod();
        }
        String queryStr = this.getQueryStr(queryMap);
        String url = this.profile.getHttpProfile().getProtocol() + this.getRootDomain() + "/" + this.profile.getHttpProfile().getToolPath() + "/" + request.getVersion() + path + "?" + queryStr;
        if (request instanceof AbstractUploadRequest) {
            AbstractUploadRequest uploadRequest = (AbstractUploadRequest)request;
            return conn.postFormRequest(url, uploadRequest.getBody(), uploadRequest.getFieldName(), uploadRequest.getFileName(), uploadRequest.getFileMime());
        }
        byte[] jsonStr = request.toBody();
        switch (reqMethod) {
            case "GET": {
                return conn.getRequest(url);
            }
            case "POST": {
                if (jsonStr == null) {
                    jsonStr = this.gson.toJson((Object)request).getBytes();
                }
                return conn.postRequest(url, jsonStr);
            }
            case "PUT": {
                if (jsonStr == null) {
                    jsonStr = this.gson.toJson((Object)request).getBytes();
                }
                return conn.putRequest(url, jsonStr);
            }
            case "DELETE": {
                return conn.deleteRequest(url);
            }
        }
        throw new CloudTestSDKException("Method only support (GET, POST, PUT, DELETE)");
    }

    private String getQueryStr(HashMap<String, Object> queryMap) {
        ArrayList parameters = new ArrayList();
        queryMap.forEach((key, value) -> parameters.add(new BasicNameValuePair(key, String.valueOf(value))));
        return URLEncodedUtils.format(parameters, (String)"utf-8");
    }

    private String getRootDomain() {
        return this.profile.getHttpProfile().getRootDomain();
    }

    private void trySetProxy(HttpConnection conn) {
        String host = this.profile.getHttpProfile().getProxyHost();
        int port = this.profile.getHttpProfile().getProxyPort();
        if (host == null || host.isEmpty()) {
            return;
        }
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        conn.setProxy(proxy);
        String username = this.profile.getHttpProfile().getProxyUser();
        String password = this.profile.getHttpProfile().getProxyPasswd();
        if (username == null || username.isEmpty()) {
            return;
        }
        conn.setProxyAuthenticator((route, response) -> {
            if (this.authed) {
                return null;
            }
            this.authed = true;
            String credential = Credentials.basic((String)username, (String)password);
            return response.request().newBuilder().header("Proxy-Authorization", credential).build();
        });
    }

    private void signParam(Map<String, Object> param, String path, String method) throws CloudTestSDKException {
        String signSource;
        Random rd = new Random();
        param.put("t", String.valueOf(System.currentTimeMillis() / 1000L));
        param.put("nonce", String.valueOf(rd.nextInt(99999)));
        if (this.credential.getSecretId() != null && !this.credential.getSecretId().isEmpty()) {
            param.put("secret_id", this.credential.getSecretId());
            param.put("secretid", this.credential.getSecretId());
        }
        try {
            signSource = Sign.getSignSource(new TreeMap<String, Object>(param), method, path);
        }
        catch (UnsupportedEncodingException e) {
            throw new CloudTestSDKException(e.getClass().getName() + "-" + e.getMessage());
        }
        String sign = Sign.sign(this.credential.getSecretKey(), signSource, this.profile.getSignMethod());
        param.put("sign", sign);
    }

    private void warmup() {
        try {
            Mac.getInstance("HmacSHA1");
            Mac.getInstance("HmacSHA256");
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Log getLogger() {
        return this.log.getLogger();
    }

    public void setLogger(Log logger) {
        this.log.setLogger(logger);
    }

    public ClientProfile getClientProfile() {
        return this.profile;
    }

    public void setClientProfile(ClientProfile profile) {
        this.profile = profile;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public void setProfile(ClientProfile profile) {
        this.profile = profile;
    }
}

