/*
 * Decompiled with CFR 0.152.
 */
package com.cloudtestapi.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TCLog
implements Interceptor {
    private boolean debug;
    private Log logger = null;
    private Gson gson = null;

    public TCLog(String name, boolean isDebug) {
        this.logger = LogFactory.getLog((String)name);
        this.debug = isDebug;
        this.gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    }

    public TCLog(Log logger, boolean isDebug) {
        this.logger = logger;
        this.debug = isDebug;
        this.gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void info(String str) {
        this.logger.info((Object)str);
    }

    public void info(String str, Throwable t) {
        this.logger.info((Object)str, t);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.debug) {
            this.logger.info((Object)("send request, request url: " + request.url()));
            this.logger.info((Object)("request header: " + request.headers().toString()));
            this.logger.info((Object)("request body: " + this.gson.toJson((Object)request.body())));
        }
        Response response = chain.proceed(request);
        if (this.debug) {
            this.logger.info((Object)("response header:" + response.headers().toString()));
            this.logger.info((Object)("response body:" + response.body().string()));
        }
        return response;
    }
}

