/*
 * Decompiled with CFR 0.152.
 */
package com.cloudtestapi.device;

import com.cloudtestapi.common.AbstractClient;
import com.cloudtestapi.common.Constants;
import com.cloudtestapi.common.Credential;
import com.cloudtestapi.common.JsonResponseModel;
import com.cloudtestapi.common.exception.CloudTestSDKException;
import com.cloudtestapi.common.profile.ClientProfile;
import com.cloudtestapi.device.models.DeviceBasicInfo;
import com.cloudtestapi.device.models.DeviceListInfo;
import com.cloudtestapi.device.models.GetDeviceStateRequest;
import com.cloudtestapi.device.models.GetDeviceStateResponse;
import com.cloudtestapi.device.models.GetDevicesByCloudIdRequest;
import com.cloudtestapi.device.models.GetDevicesResponse;
import com.cloudtestapi.device.models.GetModelListInfoRequest;
import com.cloudtestapi.device.models.GetModelListRequest;
import com.cloudtestapi.device.models.GetProjectModelListRequest;
import com.cloudtestapi.device.models.ModelList;
import com.cloudtestapi.device.models.ModelListInfo;
import com.cloudtestapi.device.models.ModelListInfoBase;
import com.cloudtestapi.device.models.ProjectModelList;
import com.cloudtestapi.device.models.ReportDeviceOfflineRequest;
import com.cloudtestapi.device.models.SoftRebootDeviceRequest;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;

public class DeviceClient
extends AbstractClient {
    private String wdbPath = "wdb";

    public DeviceClient(Credential credential) {
        this(credential, new ClientProfile());
    }

    public DeviceClient(Credential credential, ClientProfile clientProfile) {
        super(credential, clientProfile);
    }

    private GetDevicesResponse getDevicesByCloudId(GetDevicesByCloudIdRequest request) throws CloudTestSDKException {
        GetDevicesResponse rsp = null;
        String rspStr = "";
        try {
            Type type = new TypeToken<GetDevicesResponse>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (GetDevicesResponse)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return rsp;
    }

    public GetDevicesResponse getDevicesByCloudId(int cloudId) throws CloudTestSDKException {
        GetDevicesByCloudIdRequest request = new GetDevicesByCloudIdRequest();
        request.setCloudId(cloudId);
        return this.getDevicesByCloudId(request);
    }

    private DeviceBasicInfo getDeviceState(GetDeviceStateRequest request) throws CloudTestSDKException {
        GetDeviceStateResponse rsp;
        String rspStr = "";
        try {
            Type type = new TypeToken<GetDeviceStateResponse>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (GetDeviceStateResponse)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return rsp.deviceInfo;
    }

    public DeviceBasicInfo getDeviceState(Integer deviceId, Integer cloudId) throws CloudTestSDKException {
        GetDeviceStateRequest request = new GetDeviceStateRequest();
        request.setDeviceId(deviceId);
        request.setCloudId(cloudId);
        return this.getDeviceState(request);
    }

    public void reportDeviceOffline(ReportDeviceOfflineRequest request) throws CloudTestSDKException {
        this.internalRequest(request);
    }

    public void rebootDevice(ReportDeviceOfflineRequest request) throws CloudTestSDKException {
        this.internalRequest(request);
    }

    public void softRebootDevice(SoftRebootDeviceRequest request) throws CloudTestSDKException {
        this.internalRequest(request);
    }

    public ModelList[] getModelList(String projectId) throws CloudTestSDKException {
        JsonResponseModel rsp = null;
        String rspStr = "";
        try {
            GetModelListRequest request = new GetModelListRequest();
            request.setProjectId(projectId);
            Type type = new TypeToken<JsonResponseModel<ModelList[]>>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (JsonResponseModel)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return (ModelList[])rsp.data;
    }

    public ProjectModelList[] getProjectModelList(String projectId, Constants.ModelListFilterType filterType, Integer offset, Integer limit) throws CloudTestSDKException {
        JsonResponseModel rsp = null;
        String rspStr = "";
        try {
            GetProjectModelListRequest request = new GetProjectModelListRequest();
            request.setProjectId(projectId);
            request.setOffset(offset);
            request.setLimit(limit);
            if (filterType != null) {
                request.setFilterType(filterType.getCode());
            }
            Type type = new TypeToken<JsonResponseModel<ProjectModelList[]>>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (JsonResponseModel)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return (ProjectModelList[])rsp.data;
    }

    public <T extends ModelListInfoBase> T[] getProjectModelListInfo(Integer listId, Constants.ModelListFilterType filterType) throws CloudTestSDKException {
        JsonResponseModel rsp;
        block4: {
            rsp = null;
            String rspStr = "";
            try {
                GetModelListInfoRequest request = new GetModelListInfoRequest();
                request.setListId(listId);
                rspStr = this.internalRequest(request);
                if (Constants.ModelListFilterType.MODEL.equals((Object)filterType)) {
                    Type type = new TypeToken<JsonResponseModel<ModelListInfo[]>>(){}.getType();
                    rsp = (JsonResponseModel)this.gson.fromJson(rspStr, type);
                    break block4;
                }
                if (Constants.ModelListFilterType.DEVICE.equals((Object)filterType)) {
                    Type type = new TypeToken<JsonResponseModel<DeviceListInfo[]>>(){}.getType();
                    rsp = (JsonResponseModel)this.gson.fromJson(rspStr, type);
                    break block4;
                }
                throw new CloudTestSDKException("invalid filterType while querying model list info");
            }
            catch (JsonSyntaxException e) {
                throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
            }
        }
        return (ModelListInfoBase[])rsp.data;
    }

    public String wdbConnect(String address, String token, int timeOut) throws IOException, InterruptedException, CloudTestSDKException {
        String cmd = String.format("%s connect %s -t=%s", this.wdbPath, address, token);
        Process p = Runtime.getRuntime().exec(cmd);
        boolean res = p.waitFor(timeOut, TimeUnit.SECONDS);
        if (!res) {
            throw new CloudTestSDKException("wdb connect timeout");
        }
        InputStream inputStream = p.getInputStream();
        byte[] data = new byte[1024];
        StringBuilder result = new StringBuilder();
        while (inputStream.read(data) != -1) {
            result.append(new String(data));
        }
        if (result.toString().equals("")) {
            InputStream errorStream = p.getErrorStream();
            while (errorStream.read(data) != -1) {
                result.append(new String(data));
            }
        }
        return result.toString();
    }

    public void setWdbPath(String path) {
        this.wdbPath = path;
    }
}

