/*
 * Decompiled with CFR 0.152.
 */
package com.cloudtestapi.upload;

import com.cloudtestapi.common.AbstractClient;
import com.cloudtestapi.common.Credential;
import com.cloudtestapi.common.JsonResponseModel;
import com.cloudtestapi.common.exception.CloudTestSDKException;
import com.cloudtestapi.common.profile.ClientProfile;
import com.cloudtestapi.upload.models.App;
import com.cloudtestapi.upload.models.DumpAppRequest;
import com.cloudtestapi.upload.models.DumpAppResponse;
import com.cloudtestapi.upload.models.DumpAppWTRequest;
import com.cloudtestapi.upload.models.DumpScriptRequest;
import com.cloudtestapi.upload.models.DumpScriptResponse;
import com.cloudtestapi.upload.models.GetAppByMD5Request;
import com.cloudtestapi.upload.models.GetAppInfoRequest;
import com.cloudtestapi.upload.models.GetAppInfoResponse;
import com.cloudtestapi.upload.models.GetScriptInfoRequest;
import com.cloudtestapi.upload.models.GetScriptInfoResponse;
import com.cloudtestapi.upload.models.GetUploadFileIdRequest;
import com.cloudtestapi.upload.models.GetUploadFileIdResponse;
import com.cloudtestapi.upload.models.GetUploadIdFromWTRequest;
import com.cloudtestapi.upload.models.GetUploadIdFromWTResponse;
import com.cloudtestapi.upload.models.GetUploadResultFromWTRequest;
import com.cloudtestapi.upload.models.GetUploadResultFromWTResponse;
import com.cloudtestapi.upload.models.ResignDeviceIPARequest;
import com.cloudtestapi.upload.models.ResignDeviceIPAResponse;
import com.cloudtestapi.upload.models.Script;
import com.cloudtestapi.upload.models.UploadInfo;
import com.cloudtestapi.upload.models.UploadRequest;
import com.cloudtestapi.upload.models.UploadWTRequest;
import com.cloudtestapi.upload.models.WTApp;
import com.cloudtestapi.upload.models.WTUploadInfo;
import com.cloudtestapi.upload.models.WTUploadResult;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.digest.DigestUtils;

public class UploadClient
extends AbstractClient {
    public UploadClient(Credential credential) {
        this(credential, new ClientProfile());
    }

    public UploadClient(Credential credential, ClientProfile clientProfile) {
        super(credential, clientProfile);
    }

    public App getAppInfo(int appId) throws CloudTestSDKException {
        GetAppInfoRequest request = new GetAppInfoRequest();
        request.setAppId(appId);
        GetAppInfoResponse rsp = null;
        String rspStr = "";
        try {
            Type type = new TypeToken<GetAppInfoResponse>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (GetAppInfoResponse)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return rsp.app;
    }

    private Script getScriptInfo(GetScriptInfoRequest request) throws CloudTestSDKException {
        GetScriptInfoResponse rsp = null;
        String rspStr = "";
        try {
            Type type = new TypeToken<GetScriptInfoResponse>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (GetScriptInfoResponse)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return rsp.script;
    }

    public Script getScriptInfo(int scriptId) throws CloudTestSDKException {
        GetScriptInfoRequest request = new GetScriptInfoRequest();
        request.setScriptId(scriptId);
        return this.getScriptInfo(request);
    }

    public App multiPartUploadApk(String filePath) throws CloudTestSDKException {
        UploadInfo uploadInfo = this.getUploadInfo(filePath, "android");
        this.uploadChunk(filePath, uploadInfo);
        return this.dumpApk(filePath, uploadInfo);
    }

    public String getMD5(String filePath) {
        String md5;
        File f = new File(filePath);
        try {
            InputStream is = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
            md5 = DigestUtils.md5Hex((InputStream)is);
            is.close();
        }
        catch (Exception e) {
            return "";
        }
        return md5;
    }

    public App getAppByMd5(String filePath) throws CloudTestSDKException {
        String md5 = this.getMD5(filePath);
        if (md5.isEmpty()) {
            return null;
        }
        GetAppByMD5Request request = new GetAppByMD5Request();
        request.setMd5(md5);
        DumpAppResponse rsp = null;
        String rspStr = "";
        try {
            Type type = new TypeToken<DumpAppResponse>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (DumpAppResponse)this.gson.fromJson(rspStr, type);
            return rsp.app;
        }
        catch (Exception e) {
            return null;
        }
    }

    public App multiPartUploadIpa(String filePath) throws CloudTestSDKException {
        UploadInfo uploadInfo = this.getUploadInfo(filePath, "ios");
        this.uploadChunk(filePath, uploadInfo);
        return this.dumpIPA(filePath, uploadInfo);
    }

    public App uploadApp(String filePath) throws CloudTestSDKException {
        App app = this.getAppByMd5(filePath);
        if (app != null) {
            return app;
        }
        if (filePath.endsWith(".ipa")) {
            return this.multiPartUploadIpa(filePath);
        }
        return this.multiPartUploadApk(filePath);
    }

    public Script multiPartUploadScript(String filePath) throws CloudTestSDKException {
        UploadInfo uploadInfo = this.getUploadInfo(filePath, "script");
        this.uploadChunk(filePath, uploadInfo);
        return this.dumpScript(uploadInfo);
    }

    public WTApp multiPartUploadApkToWT(String filePath, String projectId) throws CloudTestSDKException {
        WTUploadInfo uploadInfo = this.getWTUploadInfo(filePath, projectId);
        WTApp app = this.dumpApkInWT(uploadInfo);
        this.uploadChunkWT(uploadInfo);
        try {
            for (int i = 0; i < 5; ++i) {
                WTUploadResult result = this.getWTUploadResult(uploadInfo);
                if (result.status == -1) {
                    throw new CloudTestSDKException("upload file to wetest failed");
                }
                if (result.status == 1) {
                    app.appHashId = result.fileHashId;
                    return app;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new CloudTestSDKException("get upload result interrupted by " + e.getMessage());
        }
        throw new CloudTestSDKException("get upload result from wetest failed, after tried 5 times");
    }

    public WTApp multiPartUploadIpaToWT(String filePath, String projectId) throws CloudTestSDKException {
        WTUploadInfo uploadInfo = this.getWTUploadInfo(filePath, projectId);
        WTApp app = this.dumpIPAinWT(uploadInfo);
        this.uploadChunkWT(uploadInfo);
        try {
            for (int i = 0; i < 5; ++i) {
                WTUploadResult result = this.getWTUploadResult(uploadInfo);
                if (result.status == -1) {
                    throw new CloudTestSDKException("upload file to wetest failed");
                }
                if (result.status == 1) {
                    app.appHashId = result.fileHashId;
                    return app;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new CloudTestSDKException("get upload result interrupted by " + e.getMessage());
        }
        throw new CloudTestSDKException("get upload result from wetest failed, after tried 5 times");
    }

    private void uploadChunkWT(WTUploadInfo uploadInfo) throws CloudTestSDKException {
        FileInputStream is;
        File f = new File(uploadInfo.path);
        try {
            is = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new CloudTestSDKException("file not found, filePath:" + uploadInfo.path);
        }
        for (int i = 0; i < uploadInfo.chunkNum; ++i) {
            int chunkSize = 0;
            byte[] chunk = i == uploadInfo.chunkNum - 1 ? new byte[(int)(uploadInfo.size - uploadInfo.chunkSize * (long)i)] : new byte[(int)uploadInfo.chunkSize];
            try {
                chunkSize = is.read(chunk);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            UploadWTRequest request = new UploadWTRequest();
            request.setBody(chunk);
            request.setChunkNum(i + 1);
            request.setUploadId(uploadInfo.uploadId);
            this.internalRequest(request);
        }
        try {
            is.close();
        }
        catch (IOException e) {
            this.getLogger().info((Object)("close file err= " + e.getMessage()));
        }
    }

    private void uploadChunk(String filePath, UploadInfo uploadInfo) throws CloudTestSDKException {
        FileInputStream is;
        File f = new File(filePath);
        try {
            is = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new CloudTestSDKException("file not found, filePath:" + filePath);
        }
        for (int i = 0; i < uploadInfo.chunkNumber; ++i) {
            int chunkSize = 0;
            byte[] chunk = i == uploadInfo.chunkNumber - 1 ? new byte[(int)(uploadInfo.fileSize - uploadInfo.chunkSize * (long)i)] : new byte[(int)uploadInfo.chunkSize];
            try {
                chunkSize = is.read(chunk);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            UploadRequest request = new UploadRequest();
            request.setFieldName("file");
            request.setFileName(uploadInfo.fileName);
            request.setFileMime("application/zip");
            request.setBody(chunk);
            request.setUploadId(uploadInfo.uploadId);
            request.setChunkNum(i + 1);
            this.internalRequest(request);
        }
    }

    private byte[] getIPADumpContent(String filePath) throws CloudTestSDKException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(bos);
        try {
            ZipFile zipFile = new ZipFile(filePath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int nRead;
                ZipEntry entry = entries.nextElement();
                String[] elems = entry.getName().split("/");
                if (elems.length != 3 || !elems[0].equals("Payload") || !elems[2].equals("Info.plist")) continue;
                InputStream is = zipFile.getInputStream(entry);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[16384];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                ZipEntry en = new ZipEntry("Info.plist");
                zos.putNextEntry(en);
                zos.write(buffer.toByteArray());
            }
            zos.closeEntry();
            zos.close();
        }
        catch (IOException e) {
            throw new CloudTestSDKException("get ipa dump file, io exception msg:" + e.getMessage());
        }
        return bos.toByteArray();
    }

    private byte[] getApkDumpContent(String filePath) throws CloudTestSDKException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(bos);
        try {
            ZipFile zipFile = new ZipFile(filePath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int nRead;
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().equals("AndroidManifest.xml") && !entry.getName().equals("resources.arsc")) continue;
                InputStream is = zipFile.getInputStream(entry);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[16384];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                ZipEntry en = new ZipEntry(entry.getName());
                zos.putNextEntry(en);
                zos.write(buffer.toByteArray());
            }
            zos.closeEntry();
            zos.close();
        }
        catch (IOException e) {
            throw new CloudTestSDKException("get apk dump file, io exception msg:" + e.getMessage());
        }
        return bos.toByteArray();
    }

    private App dumpApk(String filePath, UploadInfo uploadInfo) throws CloudTestSDKException {
        DumpAppRequest request = new DumpAppRequest();
        request.setFileName(uploadInfo.fileName);
        request.setUploadId(uploadInfo.uploadId);
        byte[] dumpContent = this.getApkDumpContent(filePath);
        request.setBody(dumpContent);
        String rspStr = "";
        try {
            Type type = new TypeToken<DumpAppResponse>(){}.getType();
            rspStr = this.internalRequest(request);
            DumpAppResponse rsp = (DumpAppResponse)this.gson.fromJson(rspStr, type);
            return rsp.app;
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
    }

    private App dumpIPA(String filePath, UploadInfo uploadInfo) throws CloudTestSDKException {
        DumpAppRequest request = new DumpAppRequest();
        request.setFileName(uploadInfo.fileName);
        request.setUploadId(uploadInfo.uploadId);
        byte[] dumpContent = this.getIPADumpContent(filePath);
        request.setBody(dumpContent);
        String rspStr = "";
        try {
            Type type = new TypeToken<DumpAppResponse>(){}.getType();
            rspStr = this.internalRequest(request);
            DumpAppResponse rsp = (DumpAppResponse)this.gson.fromJson(rspStr, type);
            return rsp.app;
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
    }

    private WTApp dumpIPAinWT(WTUploadInfo uploadInfo) throws CloudTestSDKException {
        DumpAppWTRequest request = new DumpAppWTRequest();
        request.setFileName(uploadInfo.name);
        request.setUploadId(uploadInfo.uploadId);
        byte[] dumpContent = this.getIPADumpContent(uploadInfo.path);
        request.setBody(dumpContent);
        JsonResponseModel rsp = null;
        String rspStr = "";
        try {
            Type type = new TypeToken<JsonResponseModel<WTApp>>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (JsonResponseModel)this.gson.fromJson(rspStr, type);
            return (WTApp)rsp.data;
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
    }

    private WTApp dumpApkInWT(WTUploadInfo uploadInfo) throws CloudTestSDKException {
        DumpAppWTRequest request = new DumpAppWTRequest();
        request.setFileName(uploadInfo.name);
        request.setUploadId(uploadInfo.uploadId);
        byte[] dumpContent = this.getApkDumpContent(uploadInfo.path);
        request.setBody(dumpContent);
        JsonResponseModel rsp = null;
        String rspStr = "";
        try {
            Type type = new TypeToken<JsonResponseModel<WTApp>>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (JsonResponseModel)this.gson.fromJson(rspStr, type);
            return (WTApp)rsp.data;
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
    }

    private Script dumpScript(UploadInfo uploadInfo) throws CloudTestSDKException {
        DumpScriptRequest request = new DumpScriptRequest();
        request.setUploadId(uploadInfo.uploadId);
        String rspStr = "";
        try {
            Type type = new TypeToken<DumpScriptResponse>(){}.getType();
            rspStr = this.internalRequest(request);
            DumpScriptResponse rsp = (DumpScriptResponse)this.gson.fromJson(rspStr, type);
            return rsp.script;
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
    }

    private UploadInfo getUploadInfo(String filePath, String uploadFileType) throws CloudTestSDKException {
        GetUploadFileIdResponse rsp;
        File f = new File(filePath);
        String rspStr = "";
        try {
            long fileSize = f.length();
            String fileName = f.getName();
            GetUploadFileIdRequest request = new GetUploadFileIdRequest();
            request.setFileName(fileName);
            request.setFileSize(fileSize);
            request.setUploadFileType(uploadFileType);
            Type type = new TypeToken<GetUploadFileIdResponse>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (GetUploadFileIdResponse)this.gson.fromJson(rspStr, type);
            rsp.uploadInfo.fileName = fileName;
            rsp.uploadInfo.fileType = uploadFileType;
            rsp.uploadInfo.fileSize = fileSize;
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return rsp.uploadInfo;
    }

    private WTUploadInfo getWTUploadInfo(String filePath, String projectId) throws CloudTestSDKException {
        String md5;
        File f = new File(filePath);
        long fileSize = f.length();
        String fileName = f.getName();
        try {
            InputStream is = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
            md5 = DigestUtils.md5Hex((InputStream)is);
            is.close();
        }
        catch (Exception e) {
            throw new CloudTestSDKException(e.getMessage());
        }
        GetUploadIdFromWTRequest request = new GetUploadIdFromWTRequest();
        request.setCsize(0xA00000);
        request.setSize(fileSize);
        request.setName(fileName);
        request.setProject(projectId);
        JsonResponseModel rsp = null;
        String rspStr = "";
        try {
            Type type = new TypeToken<JsonResponseModel<GetUploadIdFromWTResponse>>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (JsonResponseModel)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        WTUploadInfo uploadInfo = new WTUploadInfo();
        uploadInfo.name = fileName;
        uploadInfo.size = fileSize;
        uploadInfo.path = filePath;
        uploadInfo.md5 = md5;
        uploadInfo.uploadId = ((GetUploadIdFromWTResponse)rsp.data).id;
        uploadInfo.chunkNum = ((GetUploadIdFromWTResponse)rsp.data).chunkNumber;
        uploadInfo.chunkSize = ((GetUploadIdFromWTResponse)rsp.data).chunkSize;
        return uploadInfo;
    }

    private WTUploadResult getWTUploadResult(WTUploadInfo uploadInfo) throws CloudTestSDKException {
        String rspStr = "";
        GetUploadResultFromWTRequest request = new GetUploadResultFromWTRequest();
        request.setId(uploadInfo.uploadId);
        try {
            Type type = new TypeToken<GetUploadResultFromWTResponse>(){}.getType();
            rspStr = this.internalRequest(request);
            GetUploadResultFromWTResponse rsp = (GetUploadResultFromWTResponse)this.gson.fromJson(rspStr, type);
            if (rsp.uploadResult == null) {
                rsp.uploadResult = new WTUploadResult();
            }
            rsp.uploadResult.status = rsp.ret;
            return rsp.uploadResult;
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        catch (CloudTestSDKException e) {
            if (e.getErrorCode() == -1) {
                WTUploadResult result = new WTUploadResult();
                result.status = -1;
                return result;
            }
            throw e;
        }
    }

    public String resignDeviceIPA(Integer deviceId, String fileUrl) throws CloudTestSDKException {
        ResignDeviceIPARequest request = new ResignDeviceIPARequest();
        request.setIpaUrl(fileUrl);
        request.setDeviceId(deviceId);
        JsonResponseModel rsp = null;
        String rspStr = "";
        try {
            Type type = new TypeToken<JsonResponseModel<ResignDeviceIPAResponse>>(){}.getType();
            rspStr = this.internalRequest(request);
            rsp = (JsonResponseModel)this.gson.fromJson(rspStr, type);
        }
        catch (JsonSyntaxException e) {
            throw new CloudTestSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return ((ResignDeviceIPAResponse)rsp.data).fileUrl;
    }
}

