/*
 * Decompiled with CFR 0.152.
 */
package com.wgllss.dynamic.host.lib.loader_base;

import android.content.Context;
import com.wgllss.dynamic.host.lib.classloader.WXClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJO\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u0002H\f\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u001d"}, d2={"Lcom/wgllss/dynamic/host/lib/loader_base/DynamicManageUtils;", "", "()V", "copyFileFromAssetsToSD", "", "context", "Landroid/content/Context;", "desFile", "Ljava/io/File;", "fileName", "", "getClassImpl", "T", "cls", "Ljava/lang/Class;", "className", "existsFile", "optPath", "parent", "Ljava/lang/ClassLoader;", "ifCondition", "default", "(Ljava/lang/Class;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Ljava/lang/ClassLoader;ZLjava/lang/Object;)Ljava/lang/Object;", "getDlfn", "k", "v", "", "getDxFile", "dir", "Wgllss-Dynamic-Host-Loader-Base-Lib_release"})
public final class DynamicManageUtils {
    @NotNull
    public static final DynamicManageUtils INSTANCE = new DynamicManageUtils();

    private DynamicManageUtils() {
    }

    @NotNull
    public final String getDlfn(@NotNull String k, int v) {
        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
        String string = k + "_" + v;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().append(k\u2026\"_\").append(v).toString()");
        return string;
    }

    @NotNull
    public final File getDxFile(@NotNull Context context, @NotNull String dir, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return new File(context.getFilesDir().getAbsolutePath() + File.separator + dir + File.separator + fileName);
    }

    public final boolean copyFileFromAssetsToSD(@NotNull Context context, @NotNull File desFile, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)desFile, (String)"desFile");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        boolean copyIsFinish = false;
        try {
            File fileDir = new File(desFile.getParent());
            if (!fileDir.exists()) {
                fileDir.mkdirs();
            }
            InputStream inputStream = context.getAssets().open(fileName);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(fileName)");
            InputStream inputStream2 = inputStream;
            FileOutputStream fos = new FileOutputStream(desFile);
            byte[] temp = new byte[1024];
            int i = 0;
            while (true) {
                int n;
                int it = n = inputStream2.read(temp);
                boolean bl = false;
                i = it;
                if (n <= 0) break;
                fos.write(temp, 0, i);
            }
            fos.close();
            inputStream2.close();
            copyIsFinish = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return copyIsFinish;
    }

    public final <T> T getClassImpl(@NotNull Class<T> cls, @NotNull String className, @NotNull File existsFile, @NotNull String optPath, @NotNull ClassLoader parent, boolean ifCondition, T t) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)existsFile, (String)"existsFile");
        Intrinsics.checkNotNullParameter((Object)optPath, (String)"optPath");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return (T)(ifCondition ? new WXClassLoader(existsFile.getAbsolutePath(), optPath, parent).getInterface(cls, className) : t);
    }
}

