/*
 * Decompiled with CFR 0.152.
 */
package com.wgllss.dynamic.host.lib.runtime;

import android.text.TextUtils;
import com.wgllss.dynamic.host.lib.runtime.ContainerClassLoader;
import com.wgllss.dynamic.host.lib.runtime.InstalledApk;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/wgllss/dynamic/host/lib/runtime/MultiDynamicRuntime;", "", "()V", "findContainerClassLoader", "Lcom/wgllss/dynamic/host/lib/runtime/ContainerClassLoader;", "containerKey", "", "getParentField", "Ljava/lang/reflect/Field;", "hackContainerClassLoader", "", "containerApk", "Lcom/wgllss/dynamic/host/lib/runtime/InstalledApk;", "pathClassLoader", "Ljava/lang/ClassLoader;", "hackParentClassLoader", "classLoader", "newParentClassLoader", "loadContainerApk", "", "removeContainerClassLoader", "containerClassLoader", "Wgllss-Dynamic-Host-Runtime-Lib_release"})
public final class MultiDynamicRuntime {
    @NotNull
    public static final MultiDynamicRuntime INSTANCE = new MultiDynamicRuntime();

    private MultiDynamicRuntime() {
    }

    public final boolean loadContainerApk(@NotNull String containerKey, @NotNull InstalledApk containerApk) {
        Intrinsics.checkNotNullParameter((Object)containerKey, (String)"containerKey");
        Intrinsics.checkNotNullParameter((Object)containerApk, (String)"containerApk");
        ClassLoader pathClassLoader = MultiDynamicRuntime.class.getClassLoader();
        ContainerClassLoader containerClassLoader = this.findContainerClassLoader(containerKey);
        if (containerClassLoader != null) {
            String apkFilePath = containerClassLoader.getApkPath();
            if (TextUtils.equals((CharSequence)apkFilePath, (CharSequence)containerApk.getApkFilePath())) {
                return false;
            }
            try {
                this.removeContainerClassLoader(containerClassLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Intrinsics.checkNotNullExpressionValue((Object)pathClassLoader, (String)"pathClassLoader");
            this.hackContainerClassLoader(containerKey, containerApk, pathClassLoader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private final ContainerClassLoader findContainerClassLoader(String containerKey) {
        ClassLoader current = MultiDynamicRuntime.class.getClassLoader();
        for (ClassLoader parent = current.getParent(); parent != null; parent = parent.getParent()) {
            ClassLoader item;
            if (!(parent instanceof ContainerClassLoader) || !TextUtils.equals((CharSequence)((ContainerClassLoader)((Object)(item = parent))).getContainerKey(), (CharSequence)containerKey)) continue;
            return (ContainerClassLoader)((Object)item);
        }
        return null;
    }

    private final void removeContainerClassLoader(ContainerClassLoader containerClassLoader) throws Exception {
        ClassLoader parent;
        ClassLoader pathClassLoader;
        ClassLoader child = pathClassLoader = MultiDynamicRuntime.class.getClassLoader();
        for (parent = pathClassLoader.getParent(); parent != null && parent != containerClassLoader; parent = parent.getParent()) {
            child = parent;
        }
        if (child != null && parent == containerClassLoader) {
            this.hackParentClassLoader(child, containerClassLoader.getParent());
        }
    }

    private final void hackContainerClassLoader(String containerKey, InstalledApk containerApk, ClassLoader pathClassLoader) throws Exception {
        String string = containerApk.getApkFilePath();
        String string2 = containerApk.getODexPath();
        String string3 = containerApk.getLibraryPath();
        ClassLoader classLoader = pathClassLoader.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"pathClassLoader.parent");
        ContainerClassLoader containerClassLoader = new ContainerClassLoader(containerKey, string, string2, string3, classLoader, pathClassLoader);
        this.hackParentClassLoader(pathClassLoader, (ClassLoader)((Object)containerClassLoader));
    }

    public final void hackParentClassLoader(@Nullable ClassLoader classLoader, @Nullable ClassLoader newParentClassLoader) throws Exception {
        Field field = this.getParentField();
        if (field == null) {
            throw new RuntimeException("\u5728ClassLoader.class\u4e2d\u6ca1\u627e\u5230\u7c7b\u578b\u4e3aClassLoader\u7684parent\u57df");
        }
        Field field2 = field;
        field2.setAccessible(true);
        field2.set(classLoader, newParentClassLoader);
    }

    private final Field getParentField() {
        ClassLoader classLoader = MultiDynamicRuntime.class.getClassLoader();
        ClassLoader parent = classLoader.getParent();
        Field field = null;
        Field[] fieldArray = ClassLoader.class.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"ClassLoader::class.java.declaredFields");
        for (Field f : fieldArray) {
            try {
                boolean accessible = f.isAccessible();
                f.setAccessible(true);
                Object o = f.get(classLoader);
                f.setAccessible(accessible);
                if (o != parent) continue;
                field = f;
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return field;
    }
}

