/*
 * Decompiled with CFR 0.152.
 */
package io.github.whitedg.mybatis.crypto;

import io.github.whitedg.mybatis.crypto.IEncryptor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jasypt.util.text.TextEncryptor;

public abstract class CachedTextEncryptor
implements IEncryptor {
    private final Map<String, TextEncryptor> cache = new ConcurrentHashMap<String, TextEncryptor>();

    public String encrypt(Object plain, String key) throws Exception {
        if (plain == null) {
            return null;
        }
        return this.get(key).encrypt(plain.toString());
    }

    public String decrypt(Object cipher, String key) throws Exception {
        if (cipher == null) {
            return null;
        }
        return this.get(key).decrypt(cipher.toString());
    }

    protected TextEncryptor get(String key) {
        return this.cache.computeIfAbsent(key, this::createTextEncryptor);
    }

    protected abstract TextEncryptor createTextEncryptor(String var1);
}

