/*
 * Decompiled with CFR 0.152.
 */
package io.github.whitemagic2014.tts;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;

public class SubMaker {
    private String fullFilePath;
    private Double lastoffset = 0.0;
    private Double note = 0.0;
    private Boolean head = true;
    private List<Double[]> offset = new ArrayList<Double[]>();
    private List<String> subs = new ArrayList<String>();

    public SubMaker(String fullFilePath) {
        this.fullFilePath = fullFilePath.concat(".vtt");
        File oldFile = new File(this.fullFilePath);
        String lastNote = "NOTE0";
        if (oldFile.exists()) {
            this.head = false;
            try (BufferedReader br = new BufferedReader(new FileReader(oldFile));){
                String line = "";
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("NOTE")) continue;
                    lastNote = line;
                }
                this.lastoffset = Double.parseDouble(lastNote.replace("NOTE", ""));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void createSub(Double start, Double duration, String text) {
        this.note = this.lastoffset + start + duration;
        this.offset.add(new Double[]{this.lastoffset + start, this.lastoffset + start + duration});
        this.subs.add(text);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String generateSubs(int wordsInCue) {
        if (this.subs.size() != this.offset.size()) {
            throw new IllegalArgumentException("subs and offset are not of the same length");
        }
        if (wordsInCue <= 0) {
            throw new IllegalArgumentException("wordsInCue must be greater than 0");
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.fullFilePath, true));){
            StringBuilder data = new StringBuilder();
            if (this.head.booleanValue()) {
                bw.write("WEBVTT\r\n\r\n");
            }
            bw.write("NOTE" + this.note + "\r\n\r\n");
            bw.newLine();
            int subStateCount = 0;
            double subStateStart = -1.0;
            StringBuilder subStateSubs = new StringBuilder();
            for (int idx = 0; idx < this.offset.size(); ++idx) {
                Double[] currentOffset = this.offset.get(idx);
                double startTime = currentOffset[0];
                double endTime = currentOffset[1];
                String subsText = StringEscapeUtils.unescapeHtml4((String)this.subs.get(idx));
                if (subStateSubs.length() > 0) {
                    subStateSubs.append(" ");
                }
                subStateSubs.append(subsText);
                if (subStateStart == -1.0) {
                    subStateStart = startTime;
                }
                if (++subStateCount != wordsInCue && idx != this.offset.size() - 1) continue;
                List<String> splitSubs = this.splitStringEvery(subStateSubs.toString(), 79);
                for (int i = 0; i < splitSubs.size() - 1; ++i) {
                    String sub = splitSubs.get(i);
                    boolean splitAtWord = true;
                    if (sub.endsWith(" ")) {
                        splitSubs.set(i, sub.substring(0, sub.length() - 1));
                        splitAtWord = false;
                    }
                    if (sub.startsWith(" ")) {
                        splitSubs.set(i, sub.substring(1));
                        splitAtWord = false;
                    }
                    if (!splitAtWord) continue;
                    splitSubs.set(i, sub + "-");
                }
                data.append(this.formatter(subStateStart, endTime, String.join((CharSequence)"\r\n", splitSubs)));
                bw.write(this.formatter(subStateStart, endTime, String.join((CharSequence)"\r\n", splitSubs)));
                bw.newLine();
                subStateCount = 0;
                subStateStart = -1.0;
                subStateSubs = new StringBuilder();
            }
            String string = data.toString();
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String formatter(double startTime, double endTime, String subdata) {
        return String.format("%s --> %s\r\n%s\r\n\r\n", this.mktimestamp(startTime), this.mktimestamp(endTime), StringEscapeUtils.escapeHtml4((String)subdata));
    }

    private String mktimestamp(double timeUnit) {
        int hour = (int)Math.floor(timeUnit / Math.pow(10.0, 7.0) / 3600.0);
        int minute = (int)Math.floor(timeUnit / Math.pow(10.0, 7.0) / 60.0 % 60.0);
        double seconds = timeUnit / Math.pow(10.0, 7.0) % 60.0;
        BigDecimal secondsBD = new BigDecimal(seconds).setScale(3, 4);
        return String.format("%02d:%02d:%06.3f", hour, minute, secondsBD.doubleValue());
    }

    private List<String> splitStringEvery(String s, int interval) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < s.length(); i += interval) {
            result.add(s.substring(i, Math.min(i + interval, s.length())));
        }
        return result;
    }
}

