/*
 * Decompiled with CFR 0.152.
 */
package io.github.whitemagic2014.tts;

import io.github.whitemagic2014.tts.TTSWebsocket;
import io.github.whitemagic2014.tts.bean.Voice;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class TTS {
    private String EDGE_URL = "wss://speech.platform.bing.com/consumer/speech/synthesize/readaloud/edge/v1?TrustedClientToken=6A5AA1D4EAFF4E9FB37E23D68491D6F4";
    private String EDGE_UA = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.74 Safari/537.36 Edg/99.0.1150.55";
    private String EDGE_ORIGIN = "chrome-extension://jdiccldimpdaibmpdkjnbmckianbfold";
    private String voicesListUrl = "https://speech.platform.bing.com/consumer/speech/synthesize/readaloud/voices/list?trustedclienttoken=6A5AA1D4EAFF4E9FB37E23D68491D6F4";
    private Map<String, String> headers;
    private Voice voice;
    private String content;
    private Boolean findHeadHook = false;
    private String format = "audio-24khz-48kbitrate-mono-mp3";
    private String voicePitch = "+0Hz";
    private String voiceRate = "+0%";
    private String voiceVolume = "+0%";
    private String storage = "./storage";
    private String fileName;
    private int connectTimeout = 0;
    private Boolean overwrite = true;
    private Boolean isRateLimited = false;

    public TTS voicePitch(String voicePitch) {
        this.voicePitch = voicePitch;
        return this;
    }

    public TTS voiceRate(String voiceRate) {
        this.voiceRate = voiceRate;
        return this;
    }

    public TTS voiceVolume(String voiceVolume) {
        this.voiceVolume = voiceVolume;
        return this;
    }

    public TTS fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public TTS formatMp3() {
        this.format = "audio-24khz-48kbitrate-mono-mp3";
        return this;
    }

    public TTS formatOpus() {
        this.format = "webm-24khz-16bit-mono-opus";
        return this;
    }

    public TTS connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public TTS findHeadHook() {
        this.findHeadHook = true;
        return this;
    }

    public TTS fixHeadHook() {
        this.findHeadHook = false;
        return this;
    }

    public TTS storage(String storage) {
        this.storage = storage;
        return this;
    }

    public TTS(Voice voice, String content) {
        this.voice = voice;
        this.content = content;
    }

    public TTS headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public TTS overwrite(Boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public TTS isRateLimited(Boolean isRateLimited) {
        this.isRateLimited = isRateLimited;
        return this;
    }

    public String trans() {
        String fName;
        if (this.voice == null) {
            throw new RuntimeException("please set voice");
        }
        String str = this.removeIncompatibleCharacters(this.content);
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new RuntimeException("invalid content");
        }
        this.content = str;
        File storageFolder = new File(this.storage);
        if (!storageFolder.exists()) {
            storageFolder.mkdirs();
        }
        String dateStr = this.dateToString(new Date());
        String reqId = this.uuid();
        String audioFormat = this.mkAudioFormat(dateStr);
        String ssml = this.mkssml(this.voice.getLocale(), this.voice.getName());
        String ssmlHeadersPlusData = this.ssmlHeadersPlusData(reqId, dateStr, ssml);
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
            this.headers.put("Origin", this.EDGE_ORIGIN);
            this.headers.put("Pragma", "no-cache");
            this.headers.put("Cache-Control", "no-cache");
            this.headers.put("User-Agent", this.EDGE_UA);
        }
        String string = fName = StringUtils.isBlank((CharSequence)this.fileName) ? reqId : this.fileName;
        if (this.format.equals("audio-24khz-48kbitrate-mono-mp3")) {
            fName = fName + ".mp3";
        } else if (this.format.equals("webm-24khz-16bit-mono-opus")) {
            fName = fName + ".opus";
        }
        if (this.overwrite.booleanValue()) {
            File voiceFile = new File(this.storage + File.separator + fName);
            File subFile = new File(this.storage + File.separator + fName + ".vtt");
            if (voiceFile.exists()) {
                voiceFile.delete();
            }
            if (subFile.exists()) {
                subFile.delete();
            }
        }
        String REQUEST_EDGE_URL = this.EDGE_URL;
        if (this.isRateLimited.booleanValue()) {
            REQUEST_EDGE_URL = REQUEST_EDGE_URL + TTS.createSecMSGEC();
        }
        try {
            TTSWebsocket client = new TTSWebsocket(REQUEST_EDGE_URL, this.headers, this.connectTimeout, this.storage, fName, this.findHeadHook);
            client.connect();
            while (!client.isOpen()) {
                Thread.sleep(100L);
            }
            client.send(audioFormat);
            client.send(ssmlHeadersPlusData);
            while (client.isOpen()) {
                Thread.sleep(100L);
            }
            return fName;
        }
        catch (InterruptedException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String mkAudioFormat(String dateStr) {
        return "X-Timestamp:" + dateStr + "\r\nContent-Type:application/json; charset=utf-8\r\nPath:speech.config\r\n\r\n{\"context\":{\"synthesis\":{\"audio\":{\"metadataoptions\":{\"sentenceBoundaryEnabled\":\"false\",\"wordBoundaryEnabled\":\"true\"},\"outputFormat\":\"" + this.format + "\"}}}}\n";
    }

    private String mkssml(String locate, String voiceName) {
        return "<speak version='1.0' xmlns='http://www.w3.org/2001/10/synthesis' xml:lang='" + locate + "'><voice name='" + voiceName + "'><prosody pitch='" + this.voicePitch + "' rate='" + this.voiceRate + "' volume='" + this.voiceVolume + "'>" + this.content + "</prosody></voice></speak>";
    }

    private String ssmlHeadersPlusData(String requestId, String timestamp, String ssml) {
        return "X-RequestId:" + requestId + "\r\nContent-Type:application/ssml+xml\r\nX-Timestamp:" + timestamp + "Z\r\nPath:ssml\r\n\r\n" + ssml;
    }

    private String dateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z (zzzz)");
        return sdf.format(date);
    }

    public static String createSecMSGEC() {
        try {
            String SEC_MS_GEC_Version = "1-130.0.2849.68";
            long ticks = (long)(Math.floor((double)System.currentTimeMillis() / 1000.0 + 1.16444736E10) * 1.0E7);
            long roundedTicks = ticks - ticks % 3000000000L;
            String str = roundedTicks + "6A5AA1D4EAFF4E9FB37E23D68491D6F4";
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            byte[] hash = sha256.digest(str.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            String SEC_MS_GEC = hexString.toString().toUpperCase();
            return String.format("&Sec-MS-GEC=%s&Sec-MS-GEC-Version=%s", SEC_MS_GEC, SEC_MS_GEC_Version);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private String uuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private String removeIncompatibleCharacters(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return null;
        }
        HashMap<Character, String> escapeMap = new HashMap<Character, String>(){
            {
                this.put(Character.valueOf('<'), "&lt;");
                this.put(Character.valueOf('>'), "&gt;");
                this.put(Character.valueOf('&'), "&amp;");
                this.put(Character.valueOf('\"'), "&quot;");
                this.put(Character.valueOf('\''), "&apos;");
            }
        };
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            boolean isControlChar;
            char c = input.charAt(i);
            char code = c;
            boolean bl = isControlChar = '\u0000' <= code && code <= '\b' || '\u000b' <= code && code <= '\f' || '\u000e' <= code && code <= '\u001f';
            if (isControlChar) {
                output.append(' ');
                continue;
            }
            if (escapeMap.containsKey(Character.valueOf(c))) {
                output.append((String)escapeMap.get(Character.valueOf(c)));
                continue;
            }
            output.append(c);
        }
        return output.toString();
    }
}

