/*
 * Decompiled with CFR 0.152.
 */
package io.github.whitemagic2014.tts;

import com.alibaba.fastjson.JSONObject;
import io.github.whitemagic2014.tts.SubMaker;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;

public class TTSWebsocket
extends WebSocketClient {
    private String storage;
    private String fileName;
    private Boolean findHeadHook;
    private SubMaker subMaker;
    private static byte[] head = new byte[]{80, 97, 116, 104, 58, 97, 117, 100, 105, 111, 13, 10};

    public String getFileName() {
        return this.fileName;
    }

    public TTSWebsocket(String serverUri, Map<String, String> httpHeaders, int connectTimeout, String storage, String fileName, Boolean findHeadHook) throws URISyntaxException {
        super(new URI(serverUri), (Draft)new Draft_6455(), httpHeaders, connectTimeout);
        this.storage = storage;
        this.fileName = fileName;
        this.findHeadHook = findHeadHook;
        this.subMaker = new SubMaker(storage + File.separator + fileName);
    }

    public void onOpen(ServerHandshake handshakedata) {
    }

    public void onMessage(String message) {
        if (message.contains("Path:turn.end")) {
            this.subMaker.generateSubs(10);
            this.close();
        } else if (message.contains("\"Type\": \"WordBoundary\"")) {
            JSONObject json = JSONObject.parseObject((String)message.substring(message.indexOf("{")));
            JSONObject item = json.getJSONArray("Metadata").getJSONObject(0).getJSONObject("Data");
            this.subMaker.createSub(item.getDouble("Offset"), item.getDouble("Duration"), item.getJSONObject("text").getString("Text"));
        }
    }

    public void onMessage(ByteBuffer originBytes) {
        if (this.findHeadHook.booleanValue()) {
            this.findHeadHook(originBytes);
        } else {
            this.fixHeadHook(originBytes);
        }
    }

    private void findHeadHook(ByteBuffer originBytes) {
        byte[] origin = originBytes.array();
        int headIndex = -1;
        for (int i = 0; i < origin.length - head.length; ++i) {
            boolean match = true;
            for (int j = 0; j < head.length; ++j) {
                if (origin[i + j] == head[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            headIndex = i;
            break;
        }
        if (headIndex != -1) {
            byte[] voiceBytesRemoveHead = Arrays.copyOfRange(origin, headIndex + head.length, origin.length);
            try (FileOutputStream fos = new FileOutputStream(this.storage + File.separator + this.fileName, true);){
                fos.write(voiceBytesRemoveHead);
                fos.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void fixHeadHook(ByteBuffer originBytes) {
        String str = new String(originBytes.array());
        byte[] origin = originBytes.array();
        int skip = str.contains("Content-Type") ? (str.contains("audio/mpeg") ? 130 : (str.contains("codec=opus") ? 142 : 0)) : 105;
        byte[] voiceBytesRemoveHead = Arrays.copyOfRange(origin, skip, origin.length);
        try (FileOutputStream fos = new FileOutputStream(this.storage + File.separator + this.fileName, true);){
            fos.write(voiceBytesRemoveHead);
            fos.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onClose(int code, String reason, boolean remote) {
    }

    public void onError(Exception ex) {
        ex.printStackTrace();
    }
}

