/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.errorhandlingspringbootstarter;

import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiErrorResponse;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiExceptionHandler;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ErrorHandlingProperties;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.FallbackApiExceptionHandler;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;

@ControllerAdvice(annotations={RestController.class})
public class ErrorHandlingControllerAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandlingControllerAdvice.class);
    private final ErrorHandlingProperties properties;
    private final List<ApiExceptionHandler> handlers;
    private final FallbackApiExceptionHandler fallbackHandler;

    public ErrorHandlingControllerAdvice(ErrorHandlingProperties properties, List<ApiExceptionHandler> handlers, FallbackApiExceptionHandler fallbackHandler) {
        this.properties = properties;
        this.handlers = handlers;
        this.fallbackHandler = fallbackHandler;
        this.handlers.sort((Comparator<ApiExceptionHandler>)AnnotationAwareOrderComparator.INSTANCE);
        LOGGER.info("Error Handling Spring Boot Starter active with {} handlers", (Object)this.handlers.size());
        LOGGER.debug("Handlers: {}", this.handlers);
    }

    @ExceptionHandler
    public ResponseEntity<?> handleException(Throwable exception, WebRequest webRequest, Locale locale) {
        LOGGER.debug("webRequest: {}", (Object)webRequest);
        LOGGER.debug("locale: {}", (Object)locale);
        ApiErrorResponse errorResponse = null;
        for (ApiExceptionHandler handler : this.handlers) {
            if (!handler.canHandle(exception)) continue;
            errorResponse = handler.handle(exception);
            break;
        }
        if (errorResponse == null) {
            errorResponse = this.fallbackHandler.handle(exception);
        }
        this.logException(errorResponse, exception);
        return ResponseEntity.status((HttpStatus)errorResponse.getHttpStatus()).body((Object)errorResponse);
    }

    private void logException(ApiErrorResponse errorResponse, Throwable exception) {
        if (this.properties.getFullStacktraceClasses().contains(exception.getClass())) {
            LOGGER.error(exception.getMessage(), exception);
        } else if (!this.properties.getFullStacktraceHttpStatuses().isEmpty()) {
            boolean alreadyLogged = this.logFullStacktraceIfNeeded(errorResponse.getHttpStatus(), exception);
            if (!alreadyLogged) {
                this.doStandardFallbackLogging(exception);
            }
        } else {
            this.doStandardFallbackLogging(exception);
        }
    }

    private void doStandardFallbackLogging(Throwable exception) {
        switch (this.properties.getExceptionLogging()) {
            case WITH_STACKTRACE: {
                LOGGER.error(exception.getMessage(), exception);
                break;
            }
            case MESSAGE_ONLY: {
                LOGGER.error(exception.getMessage());
            }
        }
    }

    private boolean logFullStacktraceIfNeeded(HttpStatus httpStatus, Throwable exception) {
        String httpStatusValue = String.valueOf(httpStatus.value());
        if (this.properties.getFullStacktraceHttpStatuses().contains(httpStatusValue)) {
            LOGGER.error(exception.getMessage(), exception);
            return true;
        }
        if (this.properties.getFullStacktraceHttpStatuses().contains(httpStatusValue.replaceFirst("\\d$", "x"))) {
            LOGGER.error(exception.getMessage(), exception);
            return true;
        }
        if (this.properties.getFullStacktraceHttpStatuses().contains(httpStatusValue.replaceFirst("\\d\\d$", "xx"))) {
            LOGGER.error(exception.getMessage(), exception);
            return true;
        }
        return false;
    }
}

