/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.errorhandlingspringbootstarter.handler;

import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiErrorResponse;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.handler.AbstractApiExceptionHandler;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorCodeMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorMessageMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.HttpStatusMapper;
import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;
import org.springframework.web.server.ServerErrorException;

public class ServerErrorExceptionHandler
extends AbstractApiExceptionHandler {
    public ServerErrorExceptionHandler(HttpStatusMapper httpStatusMapper, ErrorCodeMapper errorCodeMapper, ErrorMessageMapper errorMessageMapper) {
        super(httpStatusMapper, errorCodeMapper, errorMessageMapper);
    }

    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof ServerErrorException;
    }

    @Override
    public ApiErrorResponse handle(Throwable exception) {
        Method handlerMethod;
        ServerErrorException ex = (ServerErrorException)exception;
        ApiErrorResponse response = new ApiErrorResponse(ex.getStatus(), this.getErrorCode((Throwable)ex), this.getErrorMessage((Throwable)ex));
        MethodParameter methodParameter = ex.getMethodParameter();
        if (methodParameter != null) {
            response.addErrorProperty("parameterName", methodParameter.getParameterName());
            response.addErrorProperty("parameterType", methodParameter.getParameterType().getSimpleName());
        }
        if ((handlerMethod = ex.getHandlerMethod()) != null) {
            response.addErrorProperty("methodName", handlerMethod.getName());
            response.addErrorProperty("methodClassName", handlerMethod.getDeclaringClass().getSimpleName());
        }
        return response;
    }
}

