/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.errorhandlingspringbootstarter;

import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiErrorResponse;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ErrorHandlingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatusCode;

public class LoggingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingService.class);
    private final ErrorHandlingProperties properties;

    public LoggingService(ErrorHandlingProperties properties) {
        this.properties = properties;
    }

    public void logException(ApiErrorResponse errorResponse, Throwable exception) {
        if (this.properties.getFullStacktraceClasses().contains(exception.getClass())) {
            LOGGER.error(exception.getMessage(), exception);
        } else if (!this.properties.getFullStacktraceHttpStatuses().isEmpty()) {
            boolean alreadyLogged = this.logFullStacktraceIfNeeded(errorResponse.getHttpStatus(), exception);
            if (!alreadyLogged) {
                this.doStandardFallbackLogging(exception);
            }
        } else {
            this.doStandardFallbackLogging(exception);
        }
    }

    private void doStandardFallbackLogging(Throwable exception) {
        switch (this.properties.getExceptionLogging()) {
            case WITH_STACKTRACE: {
                LOGGER.error(exception.getMessage(), exception);
                break;
            }
            case MESSAGE_ONLY: {
                LOGGER.error(exception.getMessage());
            }
        }
    }

    private boolean logFullStacktraceIfNeeded(HttpStatusCode httpStatus, Throwable exception) {
        String httpStatusValue = String.valueOf(httpStatus.value());
        if (this.properties.getFullStacktraceHttpStatuses().contains(httpStatusValue)) {
            LOGGER.error(exception.getMessage(), exception);
            return true;
        }
        if (this.properties.getFullStacktraceHttpStatuses().contains(httpStatusValue.replaceFirst("\\d$", "x"))) {
            LOGGER.error(exception.getMessage(), exception);
            return true;
        }
        if (this.properties.getFullStacktraceHttpStatuses().contains(httpStatusValue.replaceFirst("\\d\\d$", "xx"))) {
            LOGGER.error(exception.getMessage(), exception);
            return true;
        }
        return false;
    }
}

