/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.errorhandlingspringbootstarter.servlet;

import io.github.wimdeblauwe.errorhandlingspringbootstarter.AbstractErrorHandlingConfiguration;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiExceptionHandler;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ErrorHandlingProperties;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.FallbackApiExceptionHandler;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.LoggingService;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.SpringOrmErrorHandlingConfiguration;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.SpringSecurityErrorHandlingConfiguration;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ValidationErrorHandlingConfiguration;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.handler.MissingRequestValueExceptionHandler;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorCodeMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorMessageMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.HttpStatusMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.servlet.ErrorHandlingControllerAdvice;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={ErrorHandlingProperties.class})
@ConditionalOnProperty(value={"error.handling.enabled"}, matchIfMissing=true)
@PropertySource(value={"classpath:/error-handling-defaults.properties"})
@Import(value={ValidationErrorHandlingConfiguration.class, SpringSecurityErrorHandlingConfiguration.class, SpringOrmErrorHandlingConfiguration.class})
public class ServletErrorHandlingConfiguration
extends AbstractErrorHandlingConfiguration {
    @Bean
    public MissingRequestValueExceptionHandler missingRequestValueExceptionHandler(HttpStatusMapper httpStatusMapper, ErrorCodeMapper errorCodeMapper, ErrorMessageMapper errorMessageMapper) {
        return new MissingRequestValueExceptionHandler(httpStatusMapper, errorCodeMapper, errorMessageMapper);
    }

    @Bean
    public ErrorHandlingControllerAdvice errorHandlingControllerAdvice(List<ApiExceptionHandler> handlers, FallbackApiExceptionHandler fallbackApiExceptionHandler, LoggingService loggingService) {
        return new ErrorHandlingControllerAdvice(handlers, fallbackApiExceptionHandler, loggingService);
    }
}

