/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.hsbt.mvc;

import io.github.wimdeblauwe.hsbt.mvc.HtmxRequest;
import io.github.wimdeblauwe.hsbt.mvc.HtmxRequestHeader;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class HtmxHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().equals(HtmxRequest.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        return HtmxHandlerMethodArgumentResolver.createHtmxRequest(Objects.requireNonNull((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)));
    }

    public static HtmxRequest createHtmxRequest(HttpServletRequest req) {
        String hxRequestHeader = req.getHeader(HtmxRequestHeader.HX_REQUEST.getValue());
        if (hxRequestHeader == null) {
            return new HtmxRequest.Builder(false).build();
        }
        HtmxRequest.Builder builder = new HtmxRequest.Builder(true);
        if (req.getHeader(HtmxRequestHeader.HX_BOOSTED.getValue()) != null) {
            builder.withBoosted(true);
        }
        if (req.getHeader(HtmxRequestHeader.HX_CURRENT_URL.getValue()) != null) {
            builder.withCurrentUrl(req.getHeader(HtmxRequestHeader.HX_CURRENT_URL.getValue()));
        }
        if (req.getHeader(HtmxRequestHeader.HX_HISTORY_RESTORE_REQUEST.getValue()) != null) {
            builder.withHistoryRestoreRequest(true);
        }
        if (req.getHeader(HtmxRequestHeader.HX_PROMPT.getValue()) != null) {
            builder.withPromptResponse(req.getHeader(HtmxRequestHeader.HX_PROMPT.getValue()));
        }
        if (req.getHeader(HtmxRequestHeader.HX_TARGET.getValue()) != null) {
            builder.withTarget(req.getHeader(HtmxRequestHeader.HX_TARGET.getValue()));
        }
        if (req.getHeader(HtmxRequestHeader.HX_TRIGGER_NAME.getValue()) != null) {
            builder.withTriggerName(req.getHeader(HtmxRequestHeader.HX_TRIGGER_NAME.getValue()));
        }
        if (req.getHeader(HtmxRequestHeader.HX_TRIGGER.getValue()) != null) {
            builder.withTriggerId(req.getHeader(HtmxRequestHeader.HX_TRIGGER.getValue()));
        }
        return builder.build();
    }
}

