/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.hsbt.mvc;

import io.github.wimdeblauwe.hsbt.mvc.HtmxResponseHeader;
import io.github.wimdeblauwe.hsbt.mvc.HxRefresh;
import io.github.wimdeblauwe.hsbt.mvc.HxTrigger;
import io.github.wimdeblauwe.hsbt.mvc.HxTriggerLifecycle;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class HtmxHandlerInterceptor
implements HandlerInterceptor {
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (handler instanceof HandlerMethod) {
            Method method = ((HandlerMethod)handler).getMethod();
            this.setHxTrigger(response, method);
            this.setHxRefresh(response, method);
        }
    }

    private void setHxTrigger(HttpServletResponse response, Method method) {
        HxTrigger methodAnnotation = (HxTrigger)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxTrigger.class);
        if (methodAnnotation != null) {
            response.setHeader(this.getHeaderName(methodAnnotation.lifecycle()), methodAnnotation.value());
        }
    }

    private void setHxRefresh(HttpServletResponse response, Method method) {
        HxRefresh methodAnnotation = (HxRefresh)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxRefresh.class);
        if (methodAnnotation != null) {
            response.setHeader(HtmxResponseHeader.HX_REFRESH.getValue(), "true");
        }
    }

    private String getHeaderName(HxTriggerLifecycle lifecycle) {
        switch (lifecycle) {
            case RECEIVE: {
                return HtmxResponseHeader.HX_TRIGGER.getValue();
            }
            case SETTLE: {
                return HtmxResponseHeader.HX_TRIGGER_AFTER_SETTLE.getValue();
            }
            case SWAP: {
                return HtmxResponseHeader.HX_TRIGGER_AFTER_SWAP.getValue();
            }
        }
        throw new IllegalArgumentException("Unknown lifecycle:" + lifecycle);
    }
}

