/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.hsbt.mvc;

import io.github.wimdeblauwe.hsbt.mvc.HtmxRequestHeader;
import io.github.wimdeblauwe.hsbt.mvc.HxRequest;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.servlet.mvc.condition.HeadersRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class HtmxRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        HxRequest typeAnnotation = (HxRequest)AnnotationUtils.findAnnotation(handlerType, HxRequest.class);
        return this.createCondition(typeAnnotation);
    }

    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        HxRequest methodAnnotation = (HxRequest)AnnotationUtils.findAnnotation((Method)method, HxRequest.class);
        return this.createCondition(methodAnnotation);
    }

    private RequestCondition<?> createCondition(HxRequest hxRequest) {
        if (hxRequest != null) {
            return new HeadersRequestCondition(new String[]{HtmxRequestHeader.HX_REQUEST.getValue()});
        }
        return null;
    }
}

