/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.hsbt.mvc;

import io.github.wimdeblauwe.hsbt.mvc.HtmxHandlerMethodArgumentResolver;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.web.IWebExchange;
import org.thymeleaf.web.servlet.IServletWebRequest;

public class HtmxSpringStandardExressionObjectFactory
implements IExpressionObjectFactory {
    public static final String HTMX_REQUEST_EXPRESSION_OBJECT_NAME = "htmxRequest";
    public static final Set<String> ALL_EXPRESSION_OBJECT_NAMES;

    public Set<String> getAllExpressionObjectNames() {
        return ALL_EXPRESSION_OBJECT_NAMES;
    }

    public Object buildObject(IExpressionContext context, String expressionObjectName) {
        if (HTMX_REQUEST_EXPRESSION_OBJECT_NAME.equals(expressionObjectName) && context instanceof IWebContext) {
            IWebContext webContext = (IWebContext)context;
            IWebExchange exchange = webContext.getExchange();
            IServletWebRequest request = (IServletWebRequest)exchange.getRequest();
            return HtmxHandlerMethodArgumentResolver.createHtmxRequest((HttpServletRequest)request.getNativeRequestObject());
        }
        return null;
    }

    public boolean isCacheable(String expressionObjectName) {
        return HTMX_REQUEST_EXPRESSION_OBJECT_NAME.equals(expressionObjectName);
    }

    static {
        LinkedHashSet<String> allExpressionObjectNames = new LinkedHashSet<String>();
        allExpressionObjectNames.add(HTMX_REQUEST_EXPRESSION_OBJECT_NAME);
        ALL_EXPRESSION_OBJECT_NAMES = Collections.unmodifiableSet(allExpressionObjectNames);
    }
}

